/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.QueryJoinFragment;

public class QuerySelect {
    private Dialect dialect;
    private JoinFragment joins;
    private StringBuilder select = new StringBuilder();
    private StringBuilder where = new StringBuilder();
    private StringBuilder groupBy = new StringBuilder();
    private StringBuilder orderBy = new StringBuilder();
    private StringBuilder having = new StringBuilder();
    private String comment;
    private boolean distinct = false;
    private static final HashSet DONT_SPACE_TOKENS = new HashSet();

    public QuerySelect(Dialect dialect) {
        this.dialect = dialect;
        this.joins = new QueryJoinFragment(dialect, false);
    }

    public JoinFragment getJoinFragment() {
        return this.joins;
    }

    public void addSelectFragmentString(String string) {
        if (string.length() > 0 && string.charAt(0) == ',') {
            string = string.substring(1);
        }
        if ((string = string.trim()).length() > 0) {
            if (this.select.length() > 0) {
                this.select.append(", ");
            }
            this.select.append(string);
        }
    }

    public void addSelectColumn(String string, String string2) {
        this.addSelectFragmentString(string + ' ' + string2);
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public void setWhereTokens(Iterator iterator) {
        QuerySelect.appendTokens(this.where, iterator);
    }

    public void prependWhereConditions(String string) {
        if (this.where.length() > 0) {
            this.where.insert(0, string + " and ");
        } else {
            this.where.append(string);
        }
    }

    public void setGroupByTokens(Iterator iterator) {
        QuerySelect.appendTokens(this.groupBy, iterator);
    }

    public void setOrderByTokens(Iterator iterator) {
        QuerySelect.appendTokens(this.orderBy, iterator);
    }

    public void setHavingTokens(Iterator iterator) {
        QuerySelect.appendTokens(this.having, iterator);
    }

    public void addOrderBy(String string) {
        if (this.orderBy.length() > 0) {
            this.orderBy.append(", ");
        }
        this.orderBy.append(string);
    }

    public String toQueryString() {
        boolean bl;
        String string;
        StringBuilder stringBuilder = new StringBuilder(50);
        if (this.comment != null) {
            stringBuilder.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuilder.append("select ");
        if (this.distinct) {
            stringBuilder.append("distinct ");
        }
        if ((string = this.joins.toFromFragmentString()).startsWith(",")) {
            string = string.substring(1);
        } else if (string.startsWith(" inner join")) {
            string = string.substring(11);
        }
        stringBuilder.append(this.select.toString()).append(" from").append(string);
        String string2 = this.joins.toWhereFragmentString().trim();
        String string3 = this.where.toString().trim();
        boolean bl2 = string2.length() > 0;
        boolean bl3 = bl = string3.length() > 0;
        if (bl2 || bl) {
            stringBuilder.append(" where ");
            if (bl2) {
                stringBuilder.append(string2.substring(4));
            }
            if (bl) {
                if (bl2) {
                    stringBuilder.append(" and (");
                }
                stringBuilder.append(string3);
                if (bl2) {
                    stringBuilder.append(")");
                }
            }
        }
        if (this.groupBy.length() > 0) {
            stringBuilder.append(" group by ").append(this.groupBy.toString());
        }
        if (this.having.length() > 0) {
            stringBuilder.append(" having ").append(this.having.toString());
        }
        if (this.orderBy.length() > 0) {
            stringBuilder.append(" order by ").append(this.orderBy.toString());
        }
        return this.dialect.transformSelectString(stringBuilder.toString());
    }

    private static void appendTokens(StringBuilder stringBuilder, Iterator iterator) {
        boolean bl = true;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl3 = !DONT_SPACE_TOKENS.contains(string);
            boolean bl4 = string.startsWith("'");
            if (bl3 && bl && (!bl4 || !bl2)) {
                stringBuilder.append(' ');
            }
            bl = bl3;
            stringBuilder.append(string);
            bl2 = string.endsWith("'");
        }
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public QuerySelect copy() {
        QuerySelect querySelect = new QuerySelect(this.dialect);
        querySelect.joins = this.joins.copy();
        querySelect.select.append(this.select.toString());
        querySelect.where.append(this.where.toString());
        querySelect.groupBy.append(this.groupBy.toString());
        querySelect.orderBy.append(this.orderBy.toString());
        querySelect.having.append(this.having.toString());
        querySelect.comment = this.comment;
        querySelect.distinct = this.distinct;
        return querySelect;
    }

    static {
        DONT_SPACE_TOKENS.add(".");
        DONT_SPACE_TOKENS.add("+");
        DONT_SPACE_TOKENS.add("-");
        DONT_SPACE_TOKENS.add("/");
        DONT_SPACE_TOKENS.add("*");
        DONT_SPACE_TOKENS.add("<");
        DONT_SPACE_TOKENS.add(">");
        DONT_SPACE_TOKENS.add("=");
        DONT_SPACE_TOKENS.add("#");
        DONT_SPACE_TOKENS.add("~");
        DONT_SPACE_TOKENS.add("|");
        DONT_SPACE_TOKENS.add("&");
        DONT_SPACE_TOKENS.add("<=");
        DONT_SPACE_TOKENS.add(">=");
        DONT_SPACE_TOKENS.add("=>");
        DONT_SPACE_TOKENS.add("=<");
        DONT_SPACE_TOKENS.add("!=");
        DONT_SPACE_TOKENS.add("<>");
        DONT_SPACE_TOKENS.add("!#");
        DONT_SPACE_TOKENS.add("!~");
        DONT_SPACE_TOKENS.add("!<");
        DONT_SPACE_TOKENS.add("!>");
        DONT_SPACE_TOKENS.add("(");
        DONT_SPACE_TOKENS.add(")");
    }
}

