/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.StringHelper;

public class InFragment {
    public static final String NULL = "null";
    public static final String NOT_NULL = "not null";
    private String columnName;
    private List<Object> values = new ArrayList<Object>();

    public InFragment addValue(Object object) {
        this.values.add(object);
        return this;
    }

    public InFragment setColumn(String string) {
        this.columnName = string;
        return this;
    }

    public InFragment setColumn(String string, String string2) {
        this.columnName = StringHelper.qualify(string, string2);
        return this.setColumn(this.columnName);
    }

    public InFragment setFormula(String string, String string2) {
        this.columnName = StringHelper.replace(string2, "$PlaceHolder$", string);
        return this.setColumn(this.columnName);
    }

    public String toFragmentString() {
        if (this.values.size() == 0) {
            return "1=2";
        }
        StringBuilder stringBuilder = new StringBuilder(this.values.size() * 5);
        if (this.values.size() == 1) {
            Object object = this.values.get(0);
            stringBuilder.append(this.columnName);
            if (NULL.equals(object)) {
                stringBuilder.append(" is null");
            } else if (NOT_NULL.equals(object)) {
                stringBuilder.append(" is not null");
            } else {
                stringBuilder.append('=').append(object);
            }
            return stringBuilder.toString();
        }
        boolean bl = false;
        for (Object object : this.values) {
            if (NULL.equals(object)) {
                bl = true;
                continue;
            }
            if (!NOT_NULL.equals(object)) continue;
            throw new IllegalArgumentException("not null makes no sense for in expression");
        }
        if (bl) {
            stringBuilder.append('(').append(this.columnName).append(" is null or ").append(this.columnName).append(" in (");
        } else {
            stringBuilder.append(this.columnName).append(" in (");
        }
        for (Object object : this.values) {
            if (NULL.equals(object)) continue;
            stringBuilder.append(object);
            stringBuilder.append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        if (bl) {
            stringBuilder.append("))");
        } else {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

