/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Delete {
    private String tableName;
    private String versionColumnName;
    private String where;
    private Map primaryKeyColumns = new LinkedHashMap();
    private String comment;

    public Delete setComment(String string) {
        this.comment = string;
        return this;
    }

    public Delete setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public String toStatementString() {
        StringBuilder stringBuilder = new StringBuilder(this.tableName.length() + 10);
        if (this.comment != null) {
            stringBuilder.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuilder.append("delete from ").append(this.tableName);
        if (this.where != null || !this.primaryKeyColumns.isEmpty() || this.versionColumnName != null) {
            stringBuilder.append(" where ");
        }
        boolean bl = false;
        Iterator iterator = this.primaryKeyColumns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            if (iterator.hasNext()) {
                stringBuilder.append(" and ");
            }
            bl = true;
        }
        if (this.where != null) {
            if (bl) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(this.where);
            bl = true;
        }
        if (this.versionColumnName != null) {
            if (bl) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(this.versionColumnName).append("=?");
        }
        return stringBuilder.toString();
    }

    public Delete setWhere(String string) {
        this.where = string;
        return this;
    }

    public Delete addWhereFragment(String string) {
        this.where = this.where == null ? string : this.where + " and " + string;
        return this;
    }

    public Delete setPrimaryKeyColumnNames(String[] stringArray) {
        this.primaryKeyColumns.clear();
        this.addPrimaryKeyColumns(stringArray);
        return this;
    }

    public Delete addPrimaryKeyColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPrimaryKeyColumn(stringArray[i], "?");
        }
        return this;
    }

    public Delete addPrimaryKeyColumns(String[] stringArray, boolean[] blArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            this.addPrimaryKeyColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Delete addPrimaryKeyColumns(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPrimaryKeyColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public Delete addPrimaryKeyColumn(String string, String string2) {
        this.primaryKeyColumns.put(string, string2);
        return this;
    }

    public Delete setVersionColumnName(String string) {
        this.versionColumnName = string;
        return this;
    }
}

