/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

public final class Alias {
    private final int length;
    private final String suffix;

    public Alias(int n, String string) {
        this.length = string == null ? n : n - string.length();
        this.suffix = string;
    }

    public Alias(String string) {
        this.length = Integer.MAX_VALUE;
        this.suffix = string;
    }

    public String toAliasString(String string) {
        char c = string.charAt(0);
        int n = "`\"[".indexOf(c);
        String string2 = this.getUnquotedAliasString(string, n);
        if (n >= 0) {
            char c2 = "`\"]".charAt(n);
            return c + string2 + c2;
        }
        return string2;
    }

    public String toUnquotedAliasString(String string) {
        return this.getUnquotedAliasString(string);
    }

    private String getUnquotedAliasString(String string) {
        char c = string.charAt(0);
        int n = "`\"[".indexOf(c);
        return this.getUnquotedAliasString(string, n);
    }

    private String getUnquotedAliasString(String string, int n) {
        String string2 = string;
        if (n >= 0) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.length() > this.length) {
            string2 = string2.substring(0, this.length);
        }
        return this.suffix == null ? string2 : string2 + this.suffix;
    }

    public String[] toUnquotedAliasStrings(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.toUnquotedAliasString(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] toAliasStrings(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.toAliasString(stringArray[i]);
        }
        return stringArray2;
    }
}

