/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.spi;

import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceInitiator;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceBinding<R extends Service> {
    private static final Logger log = Logger.getLogger(ServiceBinding.class);
    private final ServiceLifecycleOwner lifecycleOwner;
    private final Class<R> serviceRole;
    private final ServiceInitiator<R> serviceInitiator;
    private R service;

    public ServiceBinding(ServiceLifecycleOwner serviceLifecycleOwner, Class<R> clazz, R r) {
        this.lifecycleOwner = serviceLifecycleOwner;
        this.serviceRole = clazz;
        this.serviceInitiator = null;
        this.service = r;
    }

    public ServiceBinding(ServiceLifecycleOwner serviceLifecycleOwner, ServiceInitiator<R> serviceInitiator) {
        this.lifecycleOwner = serviceLifecycleOwner;
        this.serviceRole = serviceInitiator.getServiceInitiated();
        this.serviceInitiator = serviceInitiator;
    }

    public ServiceLifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public Class<R> getServiceRole() {
        return this.serviceRole;
    }

    public ServiceInitiator<R> getServiceInitiator() {
        return this.serviceInitiator;
    }

    public R getService() {
        return this.service;
    }

    public void setService(R r) {
        if (this.service != null && log.isDebugEnabled()) {
            log.debug("Overriding existing service binding [" + this.serviceRole.getName() + "]");
        }
        this.service = r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ServiceLifecycleOwner {
        public <R extends Service> R initiateService(ServiceInitiator<R> var1);

        public <R extends Service> void configureService(ServiceBinding<R> var1);

        public <R extends Service> void injectDependencies(ServiceBinding<R> var1);

        public <R extends Service> void startService(ServiceBinding<R> var1);

        public <R extends Service> void stopService(ServiceBinding<R> var1);
    }
}

