/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatformException;
import org.jboss.logging.Logger;

public class WebSphereJtaPlatform
extends AbstractJtaPlatform {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, WebSphereJtaPlatform.class.getName());
    public static final String VERSION_5_UT_NAME = "java:comp/UserTransaction";
    public static final String VERSION_4_UT_NAME = "jta/usertransaction";
    private final Class transactionManagerAccessClass;
    private final int webSphereVersion;

    public WebSphereJtaPlatform() {
        try {
            int n;
            Class<?> clazz;
            try {
                clazz = Class.forName("com.ibm.ws.Transaction.TransactionManagerFactory");
                n = 5;
                LOG.debug("WebSphere 5.1");
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.TransactionManagerFactory");
                    n = 5;
                    LOG.debug("WebSphere 5.0");
                }
                catch (Exception exception2) {
                    clazz = Class.forName("com.ibm.ejs.jts.jta.JTSXA");
                    n = 4;
                    LOG.debug("WebSphere 4");
                }
            }
            this.transactionManagerAccessClass = clazz;
            this.webSphereVersion = n;
        }
        catch (Exception exception) {
            throw new JtaPlatformException("Could not locate WebSphere TransactionManager access class", exception);
        }
    }

    protected TransactionManager locateTransactionManager() {
        try {
            Method method = this.transactionManagerAccessClass.getMethod("getTransactionManager", new Class[0]);
            return (TransactionManager)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new JtaPlatformException("Could not obtain WebSphere TransactionManager", exception);
        }
    }

    protected UserTransaction locateUserTransaction() {
        String string = this.webSphereVersion == 5 ? VERSION_5_UT_NAME : VERSION_4_UT_NAME;
        return (UserTransaction)this.jndiService().locate(string);
    }
}

