/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.service.jta.platform.internal.BorlandEnterpriseServerJtaPlatform;
import org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.service.jta.platform.internal.JRun4JtaPlatform;
import org.hibernate.service.jta.platform.internal.NoJtaPlatform;
import org.hibernate.service.jta.platform.internal.OC4JJtaPlatform;
import org.hibernate.service.jta.platform.internal.OrionJtaPlatform;
import org.hibernate.service.jta.platform.internal.ResinJtaPlatform;
import org.hibernate.service.jta.platform.internal.SunOneJtaPlatform;
import org.hibernate.service.jta.platform.internal.TransactionManagerLookupBridge;
import org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform;
import org.hibernate.service.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.service.jta.platform.internal.WeblogicJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatformException;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.transaction.TransactionManagerLookup;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaPlatformInitiator
implements BasicServiceInitiator<JtaPlatform> {
    public static final JtaPlatformInitiator INSTANCE = new JtaPlatformInitiator();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JtaPlatformInitiator.class.getName());

    @Override
    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    public JtaPlatform initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object object = this.getConfiguredPlatform(map, serviceRegistryImplementor);
        if (object == null) {
            return new NoJtaPlatform();
        }
        return serviceRegistryImplementor.getService(ConfigurationService.class).cast(JtaPlatform.class, object);
    }

    private Object getConfiguredPlatform(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        String string;
        Object object = map.get("hibernate.transaction.jta.platform");
        if (object == null && (string = (String)map.get("hibernate.transaction.manager_lookup_class")) != null) {
            LOG.deprecatedTransactionManagerStrategy(TransactionManagerLookup.class.getName(), "hibernate.transaction.manager_lookup_class", JtaPlatform.class.getName(), "hibernate.transaction.jta.platform");
            object = this.mapLegacyClasses(string, map, serviceRegistryImplementor);
            LOG.debugf("Mapped %s -> %s", (Object)string, object);
        }
        return object;
    }

    private JtaPlatform mapLegacyClasses(String string, Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        if (string == null) {
            return null;
        }
        LOG.legacyTransactionManagerStrategy(JtaPlatform.class.getName(), "hibernate.transaction.jta.platform");
        if ("org.hibernate.transaction.BESTransactionManagerLookup".equals(string)) {
            return new BorlandEnterpriseServerJtaPlatform();
        }
        if ("org.hibernate.transaction.BTMTransactionManagerLookup".equals(string)) {
            return new BitronixJtaPlatform();
        }
        if ("org.hibernate.transaction.JBossTransactionManagerLookup".equals(string)) {
            return new JBossAppServerJtaPlatform();
        }
        if ("org.hibernate.transaction.JBossTSStandaloneTransactionManagerLookup".equals(string)) {
            return new JBossStandAloneJtaPlatform();
        }
        if ("org.hibernate.transaction.JOnASTransactionManagerLookup".equals(string)) {
            return new JOnASJtaPlatform();
        }
        if ("org.hibernate.transaction.JOTMTransactionManagerLookup".equals(string)) {
            return new JOTMJtaPlatform();
        }
        if ("org.hibernate.transaction.JRun4TransactionManagerLookup".equals(string)) {
            return new JRun4JtaPlatform();
        }
        if ("org.hibernate.transaction.OC4JTransactionManagerLookup".equals(string)) {
            return new OC4JJtaPlatform();
        }
        if ("org.hibernate.transaction.OrionTransactionManagerLookup".equals(string)) {
            return new OrionJtaPlatform();
        }
        if ("org.hibernate.transaction.ResinTransactionManagerLookup".equals(string)) {
            return new ResinJtaPlatform();
        }
        if ("org.hibernate.transaction.SunONETransactionManagerLookup".equals(string)) {
            return new SunOneJtaPlatform();
        }
        if ("org.hibernate.transaction.WeblogicTransactionManagerLookup".equals(string)) {
            return new WeblogicJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereTransactionManagerLookup".equals(string)) {
            return new WebSphereJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereExtendedJTATransactionLookup".equals(string)) {
            return new WebSphereExtendedJtaPlatform();
        }
        try {
            TransactionManagerLookup transactionManagerLookup = (TransactionManagerLookup)serviceRegistryImplementor.getService(ClassLoaderService.class).classForName(string).newInstance();
            return new TransactionManagerLookupBridge(transactionManagerLookup, JndiHelper.extractJndiProperties(map));
        }
        catch (Exception exception) {
            throw new JtaPlatformException("Unable to build " + TransactionManagerLookupBridge.class.getName() + " from specified " + TransactionManagerLookup.class.getName() + " implementation: " + string);
        }
    }
}

