/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jndi.internal;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.jndi.JndiException;
import org.hibernate.service.jndi.JndiNameException;
import org.hibernate.service.jndi.spi.JndiService;
import org.jboss.logging.Logger;

public class JndiServiceImpl
implements JndiService {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JndiServiceImpl.class.getName());
    private final Hashtable initialContextSettings;

    public JndiServiceImpl(Map map) {
        this.initialContextSettings = JndiHelper.extractJndiProperties(map);
    }

    public Object locate(String string) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(string, initialContext);
        try {
            Object object = initialContext.lookup(name);
            return object;
        }
        catch (NamingException namingException) {
            throw new JndiException("Unable to lookup JNDI name [" + string + "]", namingException);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    private InitialContext buildInitialContext() {
        try {
            return this.initialContextSettings.size() == 0 ? new InitialContext() : new InitialContext(this.initialContextSettings);
        }
        catch (NamingException namingException) {
            throw new JndiException("Unable to open InitialContext", namingException);
        }
    }

    private Name parseName(String string, Context context) {
        try {
            return context.getNameParser("").parse(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new JndiNameException("JNDI name [" + string + "] was not valid", invalidNameException);
        }
        catch (NamingException namingException) {
            throw new JndiException("Error parsing JNDI name [" + string + "]", namingException);
        }
    }

    private void cleanUp(InitialContext initialContext) {
        try {
            initialContext.close();
        }
        catch (NamingException namingException) {
            LOG.unableToCloseInitialContext(namingException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String string, Object object) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(string, initialContext);
        try {
            this.bind(name, object, initialContext);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    private void bind(Name name, Object object, Context context) {
        try {
            LOG.tracef("Binding : %s", (Object)name);
            context.rebind(name, object);
        }
        catch (Exception exception) {
            if (name.size() == 1) {
                throw new JndiException("Error performing bind [" + name + "]", exception);
            }
            Context context2 = context;
            while (name.size() > 1) {
                String string = name.get(0);
                Context context3 = null;
                try {
                    LOG.tracev("Intermediate lookup: {0}", (Object)string);
                    context3 = (Context)context2.lookup(string);
                }
                catch (NameNotFoundException nameNotFoundException) {
                }
                catch (NamingException namingException) {
                    throw new JndiException("Unanticipated error doing intermediate lookup", namingException);
                }
                if (context3 != null) {
                    LOG.tracev("Found intermediate context: {0}", (Object)string);
                } else {
                    LOG.tracev("Creating sub-context: {0}", (Object)string);
                    try {
                        context3 = context2.createSubcontext(string);
                    }
                    catch (NamingException namingException) {
                        throw new JndiException("Error creating intermediate context [" + string + "]", namingException);
                    }
                }
                context2 = context3;
                name = name.getSuffix(1);
            }
            LOG.tracev("Binding : {0}", (Object)name);
            try {
                context2.rebind(name, object);
            }
            catch (NamingException namingException) {
                throw new JndiException("Error performing intermediate bind [" + name + "]", namingException);
            }
        }
        LOG.debugf("Bound name: %s", (Object)name);
    }

    public void unbind(String string) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(string, initialContext);
        try {
            initialContext.unbind(name);
        }
        catch (Exception exception) {
            throw new JndiException("Error performing unbind [" + name + "]", exception);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }

    public void addListener(String string, NamespaceChangeListener namespaceChangeListener) {
        InitialContext initialContext = this.buildInitialContext();
        Name name = this.parseName(string, initialContext);
        try {
            ((EventContext)((Object)initialContext)).addNamingListener(name, 0, (NamingListener)namespaceChangeListener);
        }
        catch (Exception exception) {
            throw new JndiException("Unable to bind listener to namespace [" + name + "]", exception);
        }
        finally {
            this.cleanUp(initialContext);
        }
    }
}

