/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jmx.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.Service;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxServiceImpl
implements JmxService,
Stoppable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JmxServiceImpl.class.getName());
    public static final String OBJ_NAME_TEMPLATE = "%s:sessionFactory=%s,serviceRole=%s,serviceType=%s";
    private final boolean usePlatformServer;
    private final String agentId;
    private final String defaultDomain;
    private final String sessionFactoryName;
    private boolean startedServer;
    private ArrayList<ObjectName> registeredMBeans;

    public JmxServiceImpl(Map map) {
        this.usePlatformServer = ConfigurationHelper.getBoolean("hibernate.jmx.usePlatformServer", map);
        this.agentId = (String)map.get("hibernate.jmx.agentId");
        this.defaultDomain = (String)map.get("hibernate.jmx.defaultDomain");
        this.sessionFactoryName = ConfigurationHelper.getString("hibernate.jmx.sessionFactoryName", map, ConfigurationHelper.getString("hibernate.session_factory_name", map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.startedServer || this.registeredMBeans != null) {
                MBeanServer mBeanServer = this.findServer();
                if (mBeanServer == null) {
                    LOG.unableToLocateMBeanServer();
                    return;
                }
                if (this.registeredMBeans != null) {
                    for (ObjectName objectName : this.registeredMBeans) {
                        try {
                            LOG.tracev("Unregistering registered MBean [ON={0}]", (Object)objectName);
                            mBeanServer.unregisterMBean(objectName);
                        }
                        catch (Exception exception) {
                            LOG.debugf("Unable to unregsiter registered MBean [ON=%s] : %s", (Object)objectName, (Object)exception.toString());
                        }
                    }
                }
                if (this.startedServer) {
                    LOG.trace("Attempting to release created MBeanServer");
                    try {
                        MBeanServerFactory.releaseMBeanServer(mBeanServer);
                    }
                    catch (Exception exception) {
                        LOG.unableToReleaseCreatedMBeanServer(exception.toString());
                    }
                }
            }
        }
        finally {
            this.startedServer = false;
            if (this.registeredMBeans != null) {
                this.registeredMBeans.clear();
                this.registeredMBeans = null;
            }
        }
    }

    @Override
    public void registerService(Manageable manageable, Class<? extends Service> clazz) {
        String string = manageable.getManagementDomain() == null ? "org.hibernate.core" : manageable.getManagementDomain();
        String string2 = manageable.getManagementServiceType() == null ? manageable.getClass().getName() : manageable.getManagementServiceType();
        try {
            ObjectName objectName = new ObjectName(String.format(OBJ_NAME_TEMPLATE, string, this.sessionFactoryName, clazz.getName(), string2));
            this.registerMBean(objectName, manageable.getManagementBean());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new HibernateException("Unable to generate service IbjectName", malformedObjectNameException);
        }
    }

    @Override
    public void registerMBean(ObjectName objectName, Object object) {
        MBeanServer mBeanServer = this.findServer();
        if (mBeanServer == null) {
            if (this.startedServer) {
                throw new HibernateException("Could not locate previously started MBeanServer");
            }
            mBeanServer = this.startMBeanServer();
            this.startedServer = true;
        }
        try {
            mBeanServer.registerMBean(object, objectName);
            if (this.registeredMBeans == null) {
                this.registeredMBeans = new ArrayList();
            }
            this.registeredMBeans.add(objectName);
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to register MBean [ON=" + objectName + "]", exception);
        }
    }

    private MBeanServer findServer() {
        if (this.usePlatformServer) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(this.agentId);
        if (this.defaultDomain == null) {
            return arrayList.get(0);
        }
        for (MBeanServer mBeanServer : arrayList) {
            if (!this.defaultDomain.equals(mBeanServer.getDefaultDomain())) continue;
            return mBeanServer;
        }
        return null;
    }

    private MBeanServer startMBeanServer() {
        try {
            return MBeanServerFactory.createMBeanServer(this.defaultDomain);
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to start MBeanServer", exception);
        }
    }
}

