/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.CUBRIDDialect;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.DerbyTenFiveDialect;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.DerbyTenSixDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.Ingres10Dialect;
import org.hibernate.dialect.Ingres9Dialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;
import org.jboss.logging.Logger;

public class StandardDialectResolver
extends AbstractDialectResolver {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StandardDialectResolver.class.getName());

    protected Dialect resolveDialectInternal(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        int n = databaseMetaData.getDatabaseMajorVersion();
        if ("CUBRID".equalsIgnoreCase(string)) {
            return new CUBRIDDialect();
        }
        if ("HSQL Database Engine".equals(string)) {
            return new HSQLDialect();
        }
        if ("H2".equals(string)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(string)) {
            return new MySQLDialect();
        }
        if ("PostgreSQL".equals(string)) {
            int n2 = databaseMetaData.getDatabaseMinorVersion();
            if (n > 8 || n == 8 && n2 >= 2) {
                return new PostgreSQL82Dialect();
            }
            return new PostgreSQL81Dialect();
        }
        if ("Apache Derby".equals(string)) {
            int n3 = databaseMetaData.getDatabaseMinorVersion();
            if (n > 10 || n == 10 && n3 >= 7) {
                return new DerbyTenSevenDialect();
            }
            if (n == 10 && n3 == 6) {
                return new DerbyTenSixDialect();
            }
            if (n == 10 && n3 == 5) {
                return new DerbyTenFiveDialect();
            }
            return new DerbyDialect();
        }
        if ("ingres".equalsIgnoreCase(string)) {
            switch (n) {
                case 9: {
                    int n4 = databaseMetaData.getDatabaseMinorVersion();
                    if (n4 > 2) {
                        return new Ingres9Dialect();
                    }
                    return new IngresDialect();
                }
                case 10: {
                    return new Ingres10Dialect();
                }
            }
            LOG.unknownIngresVersion(n);
            return new IngresDialect();
        }
        if (string.startsWith("Microsoft SQL Server")) {
            switch (n) {
                case 8: {
                    return new SQLServerDialect();
                }
                case 9: {
                    return new SQLServer2005Dialect();
                }
                case 10: 
                case 11: {
                    return new SQLServer2008Dialect();
                }
            }
            LOG.unknownSqlServerVersion(n);
            return new SQLServerDialect();
        }
        if ("Sybase SQL Server".equals(string) || "Adaptive Server Enterprise".equals(string)) {
            return new SybaseASE15Dialect();
        }
        if (string.startsWith("Adaptive Server Anywhere")) {
            return new SybaseAnywhereDialect();
        }
        if ("Informix Dynamic Server".equals(string)) {
            return new InformixDialect();
        }
        if (string.equals("DB2 UDB for AS/400")) {
            return new DB2400Dialect();
        }
        if (string.startsWith("DB2/")) {
            return new DB2Dialect();
        }
        if ("Oracle".equals(string)) {
            switch (n) {
                case 11: {
                    return new Oracle10gDialect();
                }
                case 10: {
                    return new Oracle10gDialect();
                }
                case 9: {
                    return new Oracle9iDialect();
                }
                case 8: {
                    return new Oracle8iDialect();
                }
            }
            LOG.unknownOracleVersion(n);
        }
        return null;
    }
}

