/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectResolverSet
implements DialectResolver {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DialectResolverSet.class.getName());
    private List<DialectResolver> resolvers;

    public DialectResolverSet() {
        this(new ArrayList<DialectResolver>());
    }

    public DialectResolverSet(List<DialectResolver> list) {
        this.resolvers = list;
    }

    public DialectResolverSet(DialectResolver ... dialectResolverArray) {
        this(Arrays.asList(dialectResolverArray));
    }

    @Override
    public Dialect resolveDialect(DatabaseMetaData databaseMetaData) throws JDBCConnectionException {
        for (DialectResolver dialectResolver : this.resolvers) {
            try {
                Dialect dialect = dialectResolver.resolveDialect(databaseMetaData);
                if (dialect == null) continue;
                return dialect;
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                throw jDBCConnectionException;
            }
            catch (Exception exception) {
                LOG.exceptionInSubResolver(exception.getMessage());
            }
        }
        return null;
    }

    public void addResolver(DialectResolver dialectResolver) {
        this.resolvers.add(dialectResolver);
    }

    public void addResolverAtFirst(DialectResolver dialectResolver) {
        this.resolvers.add(0, dialectResolver);
    }
}

