/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jdbc.dialect.internal.DialectResolverSet;
import org.hibernate.service.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectResolverInitiator
implements BasicServiceInitiator<DialectResolver> {
    public static final DialectResolverInitiator INSTANCE = new DialectResolverInitiator();

    @Override
    public Class<DialectResolver> getServiceInitiated() {
        return DialectResolver.class;
    }

    @Override
    public DialectResolver initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        return new DialectResolverSet(this.determineResolvers(map, serviceRegistryImplementor));
    }

    private List<DialectResolver> determineResolvers(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        ArrayList<DialectResolver> arrayList = new ArrayList<DialectResolver>();
        String string = (String)map.get("hibernate.dialect_resolvers");
        if (StringHelper.isNotEmpty(string)) {
            ClassLoaderService classLoaderService = serviceRegistryImplementor.getService(ClassLoaderService.class);
            for (String string2 : StringHelper.split(", \n\r\f\t", string)) {
                try {
                    arrayList.add((DialectResolver)classLoaderService.classForName(string2).newInstance());
                }
                catch (HibernateException hibernateException) {
                    throw hibernateException;
                }
                catch (Exception exception) {
                    throw new ServiceException("Unable to instantiate named dialect resolver [" + string2 + "]", exception);
                }
            }
        }
        arrayList.add(new StandardDialectResolver());
        return arrayList;
    }
}

