/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.hibernate.service.spi.InjectService;

public class DialectFactoryImpl
implements DialectFactory {
    private ClassLoaderService classLoaderService;
    private DialectResolver dialectResolver;

    @InjectService
    public void setClassLoaderService(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    @InjectService
    public void setDialectResolver(DialectResolver dialectResolver) {
        this.dialectResolver = dialectResolver;
    }

    public Dialect buildDialect(Map map, Connection connection) throws HibernateException {
        String string = (String)map.get("hibernate.dialect");
        if (string != null) {
            return this.constructDialect(string);
        }
        return this.determineDialect(connection);
    }

    private Dialect constructDialect(String string) {
        try {
            return (Dialect)this.classLoaderService.classForName(string).newInstance();
        }
        catch (ClassLoadingException classLoadingException) {
            throw new HibernateException("Dialect class not found: " + string, classLoadingException);
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate dialect class", exception);
        }
    }

    private Dialect determineDialect(Connection connection) {
        if (connection == null) {
            throw new HibernateException("Connection cannot be null when 'hibernate.dialect' not set");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Dialect dialect = this.dialectResolver.resolveDialect(databaseMetaData);
            if (dialect == null) {
                throw new HibernateException("Unable to determine Dialect to use [name=" + databaseMetaData.getDatabaseProductName() + ", majorVersion=" + databaseMetaData.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
            }
            return dialect;
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sQLException);
        }
    }
}

