/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;

public class BasicDialectResolver
extends AbstractDialectResolver {
    public static final int VERSION_INSENSITIVE_VERSION = -9999;
    private final String matchingName;
    private final int matchingVersion;
    private final Class dialectClass;

    public BasicDialectResolver(String string, Class clazz) {
        this(string, -9999, clazz);
    }

    public BasicDialectResolver(String string, int n, Class clazz) {
        this.matchingName = string;
        this.matchingVersion = n;
        this.dialectClass = clazz;
    }

    protected final Dialect resolveDialectInternal(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        int n = databaseMetaData.getDatabaseMajorVersion();
        if (this.matchingName.equalsIgnoreCase(string) && (this.matchingVersion == -9999 || this.matchingVersion == n)) {
            try {
                return (Dialect)this.dialectClass.newInstance();
            }
            catch (HibernateException hibernateException) {
                throw hibernateException;
            }
            catch (Throwable throwable) {
                throw new HibernateException("Could not instantiate specified Dialect class [" + this.dialectClass.getName() + "]", throwable);
            }
        }
        return null;
    }
}

