/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.BasicSQLExceptionConverter;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.jboss.logging.Logger;

public abstract class AbstractDialectResolver
implements DialectResolver {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractDialectResolver.class.getName());

    public final Dialect resolveDialect(DatabaseMetaData databaseMetaData) {
        try {
            return this.resolveDialectInternal(databaseMetaData);
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = BasicSQLExceptionConverter.INSTANCE.convert(sQLException);
            if (jDBCException instanceof JDBCConnectionException) {
                throw jDBCException;
            }
            LOG.warnf("%s : %s", (Object)BasicSQLExceptionConverter.MSG, (Object)sQLException.getMessage());
            return null;
        }
        catch (Throwable throwable) {
            LOG.unableToExecuteResolver(this, throwable.getMessage());
            return null;
        }
    }

    protected abstract Dialect resolveDialectInternal(DatabaseMetaData var1) throws SQLException;
}

