/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.spi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceBasedMultiTenantConnectionProviderImpl
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl
implements ServiceRegistryAwareService,
Stoppable {
    public static final String TENANT_IDENTIFIER_TO_USE_FOR_ANY_KEY = "hibernate.multi_tenant.datasource.identifier_for_any";
    private Map<String, DataSource> dataSourceMap;
    private JndiService jndiService;
    private String tenantIdentifierForAny;
    private String baseJndiNamespace;

    @Override
    protected DataSource selectAnyDataSource() {
        return this.selectDataSource(this.tenantIdentifierForAny);
    }

    @Override
    protected DataSource selectDataSource(String string) {
        DataSource dataSource = this.dataSourceMap().get(string);
        if (dataSource == null) {
            dataSource = (DataSource)this.jndiService.locate(this.baseJndiNamespace + '/' + string);
            this.dataSourceMap().put(string, dataSource);
        }
        return dataSource;
    }

    private Map<String, DataSource> dataSourceMap() {
        if (this.dataSourceMap == null) {
            this.dataSourceMap = new ConcurrentHashMap<String, DataSource>();
        }
        return this.dataSourceMap;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = serviceRegistryImplementor.getService(ConfigurationService.class).getSettings().get("hibernate.connection.datasource");
        if (v == null || !String.class.isInstance(v)) {
            throw new HibernateException("Improper set up of DataSourceBasedMultiTenantConnectionProviderImpl");
        }
        String string = (String)v;
        this.jndiService = serviceRegistryImplementor.getService(JndiService.class);
        if (this.jndiService == null) {
            throw new HibernateException("Could not locate JndiService from DataSourceBasedMultiTenantConnectionProviderImpl");
        }
        Object object = this.jndiService.locate(string);
        if (object == null) {
            throw new HibernateException("JNDI name [" + string + "] could not be resolved");
        }
        if (DataSource.class.isInstance(object)) {
            int n = string.lastIndexOf("/");
            this.baseJndiNamespace = string.substring(0, n);
            this.tenantIdentifierForAny = string.substring(n + 1);
            this.dataSourceMap().put(this.tenantIdentifierForAny, (DataSource)object);
        } else if (Context.class.isInstance(object)) {
            this.baseJndiNamespace = string;
            this.tenantIdentifierForAny = (String)serviceRegistryImplementor.getService(ConfigurationService.class).getSettings().get(TENANT_IDENTIFIER_TO_USE_FOR_ANY_KEY);
            if (this.tenantIdentifierForAny == null) {
                throw new HibernateException("JNDI name named a Context, but tenant identifier to use for ANY was not specified");
            }
        } else {
            throw new HibernateException("Unknown object type [" + object.getClass().getName() + "] found in JNDI location [" + string + "]");
        }
    }

    @Override
    public void stop() {
        if (this.dataSourceMap != null) {
            this.dataSourceMap.clear();
            this.dataSourceMap = null;
        }
    }
}

