/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.jdbc.connections.spi.DataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantConnectionProviderInitiator
implements BasicServiceInitiator<MultiTenantConnectionProvider> {
    public static final MultiTenantConnectionProviderInitiator INSTANCE = new MultiTenantConnectionProviderInitiator();
    private static final Logger log = Logger.getLogger(MultiTenantConnectionProviderInitiator.class);

    @Override
    public Class<MultiTenantConnectionProvider> getServiceInitiated() {
        return MultiTenantConnectionProvider.class;
    }

    @Override
    public MultiTenantConnectionProvider initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Class clazz;
        Object v;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(map);
        if (multiTenancyStrategy == MultiTenancyStrategy.NONE || multiTenancyStrategy == MultiTenancyStrategy.DISCRIMINATOR) {
            // empty if block
        }
        if ((v = map.get("hibernate.multi_tenant_connection_provider")) == null) {
            Object v2 = map.get("hibernate.connection.datasource");
            if (v2 != null && String.class.isInstance(v2)) {
                return new DataSourceBasedMultiTenantConnectionProviderImpl();
            }
            return null;
        }
        if (MultiTenantConnectionProvider.class.isInstance(v)) {
            return (MultiTenantConnectionProvider)v;
        }
        if (Class.class.isInstance(v)) {
            clazz = (Class)v;
        } else {
            String string = v.toString();
            ClassLoaderService classLoaderService = serviceRegistryImplementor.getService(ClassLoaderService.class);
            try {
                clazz = classLoaderService.classForName(string);
            }
            catch (ClassLoadingException classLoadingException) {
                log.warn((Object)("Unable to locate specified class [" + string + "]"), classLoadingException);
                throw new ServiceException("Unable to locate specified multi-tenant connection provider [" + string + "]");
            }
        }
        try {
            return (MultiTenantConnectionProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to instantiate specified class [" + clazz.getName() + "]"), exception);
            throw new ServiceException("Unable to instantiate specified multi-tenant connection provider [" + clazz.getName() + "]");
        }
    }
}

