/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DriverManagerConnectionProviderImpl.class.getName());
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private int poolSize;
    private boolean autocommit;
    private final ArrayList<Connection> pool = new ArrayList();
    private int checkedOut = 0;
    private boolean stopped;
    private transient ServiceRegistryImplementor serviceRegistry;
    private Driver driver;

    @Override
    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (ConnectionProvider.class.equals(clazz) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    @Override
    public void configure(Map map) {
        LOG.usingHibernateBuiltInConnectionPool();
        String string = (String)map.get("hibernate.connection.driver_class");
        if (string == null) {
            LOG.jdbcDriverNotSpecified("hibernate.connection.driver_class");
        } else {
            if (this.serviceRegistry != null) {
                try {
                    this.driver = (Driver)this.serviceRegistry.getService(ClassLoaderService.class).classForName(string).newInstance();
                }
                catch (Exception exception) {
                    throw new ClassLoadingException("Specified JDBC Driver " + string + " could not be loaded", exception);
                }
            }
            try {
                this.driver = (Driver)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                try {
                    this.driver = (Driver)ReflectHelper.classForName(string).newInstance();
                }
                catch (Exception exception2) {
                    throw new HibernateException("Specified JDBC Driver " + string + " could not be loaded", exception2);
                }
            }
        }
        this.poolSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", map, 20);
        LOG.hibernateConnectionPoolSize(this.poolSize);
        this.autocommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", map);
        LOG.autoCommitMode(this.autocommit);
        this.isolation = ConfigurationHelper.getInteger("hibernate.connection.isolation", map);
        if (this.isolation != null) {
            LOG.jdbcIsolationLevel(Environment.isolationLevelToString(this.isolation));
        }
        this.url = (String)map.get("hibernate.connection.url");
        if (this.url == null) {
            String string2 = LOG.jdbcUrlNotSpecified("hibernate.connection.url");
            LOG.error(string2);
            throw new HibernateException(string2);
        }
        this.connectionProps = ConnectionProviderInitiator.getConnectionProperties(map);
        LOG.usingDriver(string, this.url);
        if (LOG.isDebugEnabled()) {
            LOG.connectionProperties(this.connectionProps);
        } else {
            LOG.connectionProperties(ConfigurationHelper.maskOut(this.connectionProps, "password"));
        }
    }

    @Override
    public void stop() {
        LOG.cleaningUpConnectionPool(this.url);
        for (Connection connection : this.pool) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                LOG.unableToClosePooledConnection(sQLException);
            }
        }
        this.pool.clear();
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        LOG.tracev("Total checked-out connections: {0}", (Object)this.checkedOut);
        Object object = this.pool;
        synchronized (object) {
            if (!this.pool.isEmpty()) {
                int n = this.pool.size() - 1;
                LOG.tracev("Using pooled JDBC connection, pool size: {0}", (Object)n);
                Connection connection = this.pool.remove(n);
                if (this.isolation != null) {
                    connection.setTransactionIsolation(this.isolation);
                }
                if (connection.getAutoCommit() != this.autocommit) {
                    connection.setAutoCommit(this.autocommit);
                }
                ++this.checkedOut;
                return connection;
            }
        }
        LOG.debug("Opening new JDBC connection");
        object = this.driver != null ? this.driver.connect(this.url, this.connectionProps) : DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            object.setTransactionIsolation(this.isolation);
        }
        if (object.getAutoCommit() != this.autocommit) {
            object.setAutoCommit(this.autocommit);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Created connection to: %s, Isolation Level: %s", (Object)this.url, (Object)object.getTransactionIsolation());
        }
        ++this.checkedOut;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(Connection connection) throws SQLException {
        --this.checkedOut;
        ArrayList<Connection> arrayList = this.pool;
        synchronized (arrayList) {
            int n = this.pool.size();
            if (n < this.poolSize) {
                LOG.tracev("Returning connection to pool, pool size: {0}", (Object)(n + 1));
                this.pool.add(connection);
                return;
            }
        }
        LOG.debug("Closing JDBC connection");
        connection.close();
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
        super.finalize();
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.serviceRegistry = serviceRegistryImplementor;
    }
}

