/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProviderInitiator
implements BasicServiceInitiator<ConnectionProvider> {
    public static final ConnectionProviderInitiator INSTANCE = new ConnectionProviderInitiator();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ConnectionProviderInitiator.class.getName());
    public static final String C3P0_PROVIDER_CLASS_NAME = "org.hibernate.service.jdbc.connections.internal.C3P0ConnectionProvider";
    public static final String PROXOOL_PROVIDER_CLASS_NAME = "org.hibernate.service.jdbc.connections.internal.ProxoolConnectionProvider";
    public static final String INJECTION_DATA = "hibernate.connection_provider.injection_data";
    private static final Map<String, String> LEGACY_CONNECTION_PROVIDER_MAPPING = new HashMap<String, String>(5);
    private static final Set<String> SPECIAL_PROPERTIES;
    private static final Map<String, String> CONDITIONAL_PROPERTIES;

    @Override
    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    @Override
    public ConnectionProvider initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Map map2;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(map);
        if (multiTenancyStrategy == MultiTenancyStrategy.DATABASE || multiTenancyStrategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        ClassLoaderService classLoaderService = serviceRegistryImplementor.getService(ClassLoaderService.class);
        ConnectionProvider connectionProvider = null;
        String string = this.getConfiguredConnectionProviderName(map);
        if (string != null) {
            connectionProvider = this.instantiateExplicitConnectionProvider(string, classLoaderService);
        } else if (map.get("hibernate.connection.datasource") != null) {
            connectionProvider = new DatasourceConnectionProviderImpl();
        }
        if (connectionProvider == null && ConnectionProviderInitiator.c3p0ConfigDefined(map) && this.c3p0ProviderPresent(classLoaderService)) {
            connectionProvider = this.instantiateExplicitConnectionProvider(C3P0_PROVIDER_CLASS_NAME, classLoaderService);
        }
        if (connectionProvider == null && ConnectionProviderInitiator.proxoolConfigDefined(map) && this.proxoolProviderPresent(classLoaderService)) {
            connectionProvider = this.instantiateExplicitConnectionProvider(PROXOOL_PROVIDER_CLASS_NAME, classLoaderService);
        }
        if (connectionProvider == null && map.get("hibernate.connection.url") != null) {
            connectionProvider = new DriverManagerConnectionProviderImpl();
        }
        if (connectionProvider == null) {
            LOG.noAppropriateConnectionProvider();
            connectionProvider = new UserSuppliedConnectionProviderImpl();
        }
        if ((map2 = (Map)map.get(INJECTION_DATA)) != null && map2.size() > 0) {
            final ConnectionProvider connectionProvider2 = connectionProvider;
            new BeanInfoHelper(connectionProvider.getClass()).applyToBeanInfo(connectionProvider, new BeanInfoHelper.BeanInfoDelegate(){

                public void processBeanInfo(BeanInfo beanInfo) throws Exception {
                    PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    int n = propertyDescriptorArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string = propertyDescriptorArray[i].getName();
                        if (!map2.containsKey(string)) continue;
                        Method method = propertyDescriptorArray[i].getWriteMethod();
                        method.invoke((Object)connectionProvider2, map2.get(string));
                    }
                }
            });
        }
        return connectionProvider;
    }

    private String getConfiguredConnectionProviderName(Map map) {
        String string = (String)map.get("hibernate.connection.provider_class");
        if (LEGACY_CONNECTION_PROVIDER_MAPPING.containsKey(string)) {
            String string2 = LEGACY_CONNECTION_PROVIDER_MAPPING.get(string);
            LOG.providerClassDeprecated(string, string2);
            string = string2;
        }
        return string;
    }

    private ConnectionProvider instantiateExplicitConnectionProvider(String string, ClassLoaderService classLoaderService) {
        try {
            LOG.instantiatingExplicitConnectionProvider(string);
            return (ConnectionProvider)classLoaderService.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate connection provider [" + string + "]", exception);
        }
    }

    private boolean c3p0ProviderPresent(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(C3P0_PROVIDER_CLASS_NAME);
        }
        catch (Exception exception) {
            LOG.c3p0ProviderClassNotFound(C3P0_PROVIDER_CLASS_NAME);
            return false;
        }
        return true;
    }

    private static boolean c3p0ConfigDefined(Map map) {
        for (Object k : map.keySet()) {
            if (!String.class.isInstance(k) || !((String)k).startsWith("hibernate.c3p0")) continue;
            return true;
        }
        return false;
    }

    private boolean proxoolProviderPresent(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(PROXOOL_PROVIDER_CLASS_NAME);
        }
        catch (Exception exception) {
            LOG.proxoolProviderClassNotFound(PROXOOL_PROVIDER_CLASS_NAME);
            return false;
        }
        return true;
    }

    private static boolean proxoolConfigDefined(Map map) {
        for (Object k : map.keySet()) {
            if (!String.class.isInstance(k) || !((String)k).startsWith("hibernate.proxool")) continue;
            return true;
        }
        return false;
    }

    public static Properties getConnectionProperties(Map<?, ?> map) {
        Properties properties = new Properties();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!String.class.isInstance(entry.getKey()) || !String.class.isInstance(entry.getValue())) continue;
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string.startsWith("hibernate.connection")) {
                if (SPECIAL_PROPERTIES.contains(string)) {
                    if (!"hibernate.connection.username".equals(string)) continue;
                    properties.setProperty("user", string2);
                    continue;
                }
                properties.setProperty(string.substring("hibernate.connection".length() + 1), string2);
                continue;
            }
            if (!CONDITIONAL_PROPERTIES.containsKey(string)) continue;
            properties.setProperty(CONDITIONAL_PROPERTIES.get(string), string2);
        }
        return properties;
    }

    static {
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.DatasourceConnectionProvider", DatasourceConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.DriverManagerConnectionProvider", DriverManagerConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.UserSuppliedConnectionProvider", UserSuppliedConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.C3P0ConnectionProvider", C3P0_PROVIDER_CLASS_NAME);
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.ProxoolConnectionProvider", PROXOOL_PROVIDER_CLASS_NAME);
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
        CONDITIONAL_PROPERTIES = new HashMap<String, String>();
        CONDITIONAL_PROPERTIES.put("hibernate.synonyms", "includeSynonyms");
    }
}

