/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements ServiceRegistry {
    private final Map configurationValues;

    public StandardServiceRegistryImpl(BootstrapServiceRegistry bootstrapServiceRegistry, List<BasicServiceInitiator> list, List<ProvidedService> list2, Map<?, ?> map) {
        super(bootstrapServiceRegistry);
        this.configurationValues = map;
        for (ServiceInitiator object : list) {
            this.createServiceBinding(object);
        }
        for (ProvidedService providedService : list2) {
            this.createServiceBinding(providedService);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        return ((BasicServiceInitiator)serviceInitiator).initiateService(this.configurationValues, this);
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        if (Configurable.class.isInstance(serviceBinding.getService())) {
            ((Configurable)serviceBinding.getService()).configure(this.configurationValues);
        }
    }
}

