/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.StandardSessionFactoryServiceInitiators;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFactoryServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements SessionFactoryServiceRegistry {
    private final Configuration configuration;
    private final MetadataImplementor metadata;
    private final SessionFactoryImplementor sessionFactory;

    public SessionFactoryServiceRegistryImpl(ServiceRegistryImplementor serviceRegistryImplementor, SessionFactoryImplementor sessionFactoryImplementor, Configuration configuration) {
        super(serviceRegistryImplementor);
        this.sessionFactory = sessionFactoryImplementor;
        this.configuration = configuration;
        this.metadata = null;
        for (SessionFactoryServiceInitiator sessionFactoryServiceInitiator : StandardSessionFactoryServiceInitiators.LIST) {
            this.createServiceBinding(sessionFactoryServiceInitiator);
        }
    }

    public SessionFactoryServiceRegistryImpl(ServiceRegistryImplementor serviceRegistryImplementor, SessionFactoryImplementor sessionFactoryImplementor, MetadataImplementor metadataImplementor) {
        super(serviceRegistryImplementor);
        this.sessionFactory = sessionFactoryImplementor;
        this.configuration = null;
        this.metadata = metadataImplementor;
        for (SessionFactoryServiceInitiator sessionFactoryServiceInitiator : StandardSessionFactoryServiceInitiators.LIST) {
            this.createServiceBinding(sessionFactoryServiceInitiator);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        SessionFactoryServiceInitiator sessionFactoryServiceInitiator = (SessionFactoryServiceInitiator)serviceInitiator;
        if (this.metadata != null) {
            return sessionFactoryServiceInitiator.initiateService(this.sessionFactory, this.metadata, (ServiceRegistryImplementor)this);
        }
        if (this.configuration != null) {
            return sessionFactoryServiceInitiator.initiateService(this.sessionFactory, this.configuration, (ServiceRegistryImplementor)this);
        }
        throw new IllegalStateException("Both metadata and configuration are null.");
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
    }
}

