/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.XsdException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;
import org.xml.sax.SAXException;

public class JaxbProcessor {
    private static final Logger log = Logger.getLogger(JaxbProcessor.class);
    private final ClassLoaderService classLoaderService;
    private XMLInputFactory staxFactory;
    private Schema schema;

    public JaxbProcessor(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxbHibernateConfiguration unmarshal(InputStream inputStream, Origin origin) {
        JaxbHibernateConfiguration jaxbHibernateConfiguration;
        XMLStreamReader xMLStreamReader = this.staxFactory().createXMLStreamReader(inputStream);
        try {
            jaxbHibernateConfiguration = this.unmarshal(xMLStreamReader, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    xMLStreamReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MappingException("Unable to create stax reader", xMLStreamException, origin);
            }
        }
        try {
            xMLStreamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jaxbHibernateConfiguration;
    }

    private XMLInputFactory staxFactory() {
        if (this.staxFactory == null) {
            this.staxFactory = this.buildStaxFactory();
        }
        return this.staxFactory;
    }

    private XMLInputFactory buildStaxFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        return xMLInputFactory;
    }

    private JaxbHibernateConfiguration unmarshal(XMLStreamReader xMLStreamReader, Origin origin) {
        ContextProvidingValidationEventHandler contextProvidingValidationEventHandler = new ContextProvidingValidationEventHandler();
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{JaxbHibernateConfiguration.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.setSchema(this.schema());
            unmarshaller.setEventHandler((ValidationEventHandler)contextProvidingValidationEventHandler);
            Object object = unmarshaller.unmarshal(xMLStreamReader);
            return (JaxbHibernateConfiguration)object;
        }
        catch (JAXBException jAXBException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to perform unmarshalling at line number ").append(contextProvidingValidationEventHandler.getLineNumber()).append(" and column ").append(contextProvidingValidationEventHandler.getColumnNumber()).append(" in ").append(origin.getType().name()).append(" ").append(origin.getName()).append(". Message: ").append(contextProvidingValidationEventHandler.getMessage());
            throw new ConfigurationException(stringBuilder.toString(), jAXBException);
        }
    }

    private Schema schema() {
        if (this.schema == null) {
            this.schema = this.resolveLocalSchema("org/hibernate/hibernate-configuration-4.0.xsd");
        }
        return this.schema;
    }

    private Schema resolveLocalSchema(String string) {
        return this.resolveLocalSchema(string, "http://www.w3.org/2001/XMLSchema");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema resolveLocalSchema(String string, String string2) {
        URL uRL = this.classLoaderService.locateResource(string);
        if (uRL == null) {
            throw new XsdException("Unable to locate schema [" + string + "] via classpath", string);
        }
        try {
            InputStream inputStream = uRL.openStream();
            try {
                StreamSource streamSource = new StreamSource(uRL.openStream());
                SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
                Schema schema = schemaFactory.newSchema(streamSource);
                return schema;
            }
            catch (SAXException sAXException) {
                throw new XsdException("Unable to load schema [" + string + "]", sAXException, string);
            }
            catch (IOException iOException) {
                throw new XsdException("Unable to load schema [" + string + "]", iOException, string);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.debugf("Problem closing schema stream [%s]", (Object)iOException.toString());
                }
            }
        }
        catch (IOException iOException) {
            throw new XsdException("Stream error handling schema url [" + uRL.toExternalForm() + "]", string);
        }
    }

    static class ContextProvidingValidationEventHandler
    implements ValidationEventHandler {
        private int lineNumber;
        private int columnNumber;
        private String message;

        ContextProvidingValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            ValidationEventLocator validationEventLocator = validationEvent.getLocator();
            this.lineNumber = validationEventLocator.getLineNumber();
            this.columnNumber = validationEventLocator.getColumnNumber();
            this.message = validationEvent.getMessage();
            return false;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

