/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.LinkedHashSet;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapServiceRegistryImpl
implements ServiceRegistryImplementor,
BootstrapServiceRegistry,
ServiceBinding.ServiceLifecycleOwner {
    private static final LinkedHashSet<Integrator> NO_INTEGRATORS = new LinkedHashSet();
    private final ServiceBinding<ClassLoaderService> classLoaderServiceBinding;
    private final ServiceBinding<IntegratorService> integratorServiceBinding;

    public BootstrapServiceRegistryImpl() {
        this((ClassLoaderService)new ClassLoaderServiceImpl(), NO_INTEGRATORS);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, IntegratorService integratorService) {
        this.classLoaderServiceBinding = new ServiceBinding<ClassLoaderService>(this, ClassLoaderService.class, classLoaderService);
        this.integratorServiceBinding = new ServiceBinding<IntegratorService>(this, IntegratorService.class, integratorService);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, LinkedHashSet<Integrator> linkedHashSet) {
        this(classLoaderService, new IntegratorServiceImpl(linkedHashSet, classLoaderService));
    }

    @Override
    public <R extends Service> R getService(Class<R> clazz) {
        ServiceBinding<R> serviceBinding = this.locateServiceBinding(clazz);
        return serviceBinding == null ? null : (R)serviceBinding.getService();
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> clazz) {
        if (ClassLoaderService.class.equals(clazz)) {
            return this.classLoaderServiceBinding;
        }
        if (IntegratorService.class.equals(clazz)) {
            return this.integratorServiceBinding;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return null;
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void injectDependencies(ServiceBinding<R> serviceBinding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void startService(ServiceBinding<R> serviceBinding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void stopService(ServiceBinding<R> serviceBinding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }
}

