/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.ServiceDependencyException;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.InjectService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceRegistryImpl
implements ServiceRegistryImplementor,
ServiceBinding.ServiceLifecycleOwner {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractServiceRegistryImpl.class.getName());
    private final ServiceRegistryImplementor parent;
    private final ConcurrentHashMap<Class, ServiceBinding> serviceBindingMap = CollectionHelper.concurrentMap(20);
    private final List<ServiceBinding> serviceBindingList = CollectionHelper.arrayList(20);

    protected AbstractServiceRegistryImpl() {
        this((ServiceRegistryImplementor)null);
    }

    protected AbstractServiceRegistryImpl(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.parent = serviceRegistryImplementor;
    }

    public AbstractServiceRegistryImpl(BootstrapServiceRegistry bootstrapServiceRegistry) {
        if (!ServiceRegistryImplementor.class.isInstance(bootstrapServiceRegistry)) {
            throw new IllegalArgumentException("Boot-strap registry was not ");
        }
        this.parent = (ServiceRegistryImplementor)((Object)bootstrapServiceRegistry);
    }

    protected <R extends Service> void createServiceBinding(ServiceInitiator<R> serviceInitiator) {
        this.serviceBindingMap.put(serviceInitiator.getServiceInitiated(), new ServiceBinding<R>(this, serviceInitiator));
    }

    protected <R extends Service> void createServiceBinding(ProvidedService<R> providedService) {
        ServiceBinding<Object> serviceBinding = this.locateServiceBinding(providedService.getServiceRole(), false);
        if (serviceBinding == null) {
            serviceBinding = new ServiceBinding<Service>(this, providedService.getServiceRole(), (Service)providedService.getService());
            this.serviceBindingMap.put(providedService.getServiceRole(), serviceBinding);
        }
        this.registerService(serviceBinding, (Service)providedService.getService());
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return this.parent;
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> clazz) {
        return this.locateServiceBinding(clazz, true);
    }

    protected <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> clazz, boolean bl) {
        ServiceBinding<R> serviceBinding = this.serviceBindingMap.get(clazz);
        if (serviceBinding == null && bl && this.parent != null) {
            serviceBinding = this.parent.locateServiceBinding(clazz);
        }
        return serviceBinding;
    }

    @Override
    public <R extends Service> R getService(Class<R> clazz) {
        ServiceBinding<R> serviceBinding = this.locateServiceBinding(clazz);
        if (serviceBinding == null) {
            throw new UnknownServiceException(clazz);
        }
        R r = serviceBinding.getService();
        if (r == null) {
            r = this.initializeService(serviceBinding);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends Service> void registerService(ServiceBinding<R> serviceBinding, R r) {
        serviceBinding.setService(r);
        List<ServiceBinding> list = this.serviceBindingList;
        synchronized (list) {
            this.serviceBindingList.add(serviceBinding);
        }
    }

    private <R extends Service> R initializeService(ServiceBinding<R> serviceBinding) {
        R r;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Initializing service [role={0}]", (Object)serviceBinding.getServiceRole().getName());
        }
        if ((r = this.createService(serviceBinding)) == null) {
            return null;
        }
        serviceBinding.getLifecycleOwner().injectDependencies(serviceBinding);
        serviceBinding.getLifecycleOwner().configureService(serviceBinding);
        serviceBinding.getLifecycleOwner().startService(serviceBinding);
        return r;
    }

    protected <R extends Service> R createService(ServiceBinding<R> serviceBinding) {
        ServiceInitiator<R> serviceInitiator = serviceBinding.getServiceInitiator();
        if (serviceInitiator == null) {
            throw new UnknownServiceException(serviceBinding.getServiceRole());
        }
        try {
            R r = serviceBinding.getLifecycleOwner().initiateService(serviceInitiator);
            this.registerService(serviceBinding, r);
            return r;
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (Exception exception) {
            throw new ServiceException("Unable to create requested service [" + serviceBinding.getServiceRole().getName() + "]", exception);
        }
    }

    @Override
    public <R extends Service> void injectDependencies(ServiceBinding<R> serviceBinding) {
        R r = serviceBinding.getService();
        this.applyInjections(r);
        if (ServiceRegistryAwareService.class.isInstance(r)) {
            ((ServiceRegistryAwareService)r).injectServices(this);
        }
    }

    private <R extends Service> void applyInjections(R r) {
        try {
            for (Method method : r.getClass().getMethods()) {
                InjectService injectService = method.getAnnotation(InjectService.class);
                if (injectService == null) continue;
                this.processInjection(r, method, injectService);
            }
        }
        catch (NullPointerException nullPointerException) {
            LOG.error("NPE injecting service deps : " + r.getClass().getName());
        }
    }

    private <T extends Service> void processInjection(T t, Method method, InjectService injectService) {
        Object obj;
        if (method.getParameterTypes() == null || method.getParameterTypes().length != 1) {
            throw new ServiceDependencyException("Encountered @InjectService on method with unexpected number of parameters");
        }
        Class<?> clazz = injectService.serviceRole();
        if (clazz == null || clazz.equals(Void.class)) {
            clazz = method.getParameterTypes()[0];
        }
        if ((obj = this.getService(clazz)) == null) {
            if (injectService.required()) {
                throw new ServiceDependencyException("Dependency [" + clazz + "] declared by service [" + t + "] not found");
            }
        } else {
            try {
                method.invoke(t, obj);
            }
            catch (Exception exception) {
                throw new ServiceDependencyException("Cannot inject dependency service", exception);
            }
        }
    }

    @Override
    public <R extends Service> void startService(ServiceBinding<R> serviceBinding) {
        if (Startable.class.isInstance(serviceBinding.getService())) {
            ((Startable)serviceBinding.getService()).start();
        }
        if (Manageable.class.isInstance(serviceBinding.getService())) {
            this.getService(JmxService.class).registerService((Manageable)serviceBinding.getService(), serviceBinding.getServiceRole());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        List<ServiceBinding> list = this.serviceBindingList;
        synchronized (list) {
            ListIterator<ServiceBinding> listIterator = this.serviceBindingList.listIterator(this.serviceBindingList.size());
            while (listIterator.hasPrevious()) {
                ServiceBinding serviceBinding = listIterator.previous();
                serviceBinding.getLifecycleOwner().stopService(serviceBinding);
            }
            this.serviceBindingList.clear();
        }
        this.serviceBindingMap.clear();
    }

    @Override
    public <R extends Service> void stopService(ServiceBinding<R> serviceBinding) {
        R r = serviceBinding.getService();
        if (Stoppable.class.isInstance(r)) {
            try {
                ((Stoppable)r).stop();
            }
            catch (Exception exception) {
                LOG.unableToStopService(r.getClass(), exception.toString());
            }
        }
    }
}

