/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.config.internal;

import java.util.Collections;
import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
implements ConfigurationService,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ConfigurationServiceImpl.class.getName());
    private final Map settings;
    private ServiceRegistryImplementor serviceRegistry;

    public ConfigurationServiceImpl(Map map) {
        this.settings = Collections.unmodifiableMap(map);
    }

    @Override
    public Map getSettings() {
        return this.settings;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.serviceRegistry = serviceRegistryImplementor;
    }

    @Override
    public <T> T getSetting(String string, ConfigurationService.Converter<T> converter) {
        return this.getSetting(string, converter, null);
    }

    @Override
    public <T> T getSetting(String string, ConfigurationService.Converter<T> converter, T t) {
        Object v = this.settings.get(string);
        if (v == null) {
            return t;
        }
        return converter.convert(v);
    }

    @Override
    public <T> T getSetting(String string, Class<T> clazz, T t) {
        Object v = this.settings.get(string);
        T t2 = this.cast(clazz, v);
        return t2 != null ? t2 : t;
    }

    @Override
    public <T> T cast(Class<T> clazz, Object object) {
        Class clazz2;
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (Class.class.isInstance(object)) {
            clazz2 = (Class)Class.class.cast(object);
        } else {
            try {
                clazz2 = this.serviceRegistry.getService(ClassLoaderService.class).classForName(object.toString());
            }
            catch (ClassLoadingException classLoadingException) {
                LOG.debugf("Unable to locate %s implementation class %s", (Object)clazz.getName(), (Object)object.toString());
                clazz2 = null;
            }
        }
        if (clazz2 != null) {
            try {
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                LOG.debugf("Unable to instantiate %s class %s", (Object)clazz.getName(), (Object)clazz2.getName());
            }
        }
        return null;
    }
}

