/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.classloading.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private static final Logger log = Logger.getLogger(ClassLoaderServiceImpl.class);
    private final ClassLoader aggregatedClassLoader;

    public ClassLoaderServiceImpl() {
        this(ClassLoaderServiceImpl.class.getClassLoader());
    }

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this(Collections.singletonList(classLoader));
    }

    public ClassLoaderServiceImpl(List<ClassLoader> list) {
        ClassLoader classLoader2;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (list != null) {
            for (ClassLoader classLoader2 : list) {
                if (classLoader2 == null) continue;
                linkedHashSet.add(classLoader2);
            }
        }
        if (ClassLoaderHelper.overridenClassLoader != null) {
            linkedHashSet.add(ClassLoaderHelper.overridenClassLoader);
        }
        linkedHashSet.add(ClassLoaderServiceImpl.class.getClassLoader());
        ClassLoader classLoader3 = ClassLoaderServiceImpl.locateTCCL();
        if (classLoader3 != null) {
            linkedHashSet.add(classLoader3);
        }
        if ((classLoader2 = ClassLoaderServiceImpl.locateSystemClassLoader()) != null) {
            linkedHashSet.add(classLoader2);
        }
        this.aggregatedClassLoader = new AggregatedClassLoader(linkedHashSet);
    }

    @Deprecated
    public static ClassLoaderServiceImpl fromConfigSettings(Map map) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        Collection collection = (Collection)map.get("hibernate.classLoaders");
        if (collection != null) {
            for (ClassLoader classLoader : collection) {
                arrayList.add(classLoader);
            }
        }
        ClassLoaderServiceImpl.addIfSet(arrayList, "hibernate.classLoader.application", map);
        ClassLoaderServiceImpl.addIfSet(arrayList, "hibernate.classLoader.resources", map);
        ClassLoaderServiceImpl.addIfSet(arrayList, "hibernate.classLoader.hibernate", map);
        ClassLoaderServiceImpl.addIfSet(arrayList, "hibernate.classLoader.environment", map);
        return new ClassLoaderServiceImpl(arrayList);
    }

    private static void addIfSet(List<ClassLoader> list, String string, Map map) {
        ClassLoader classLoader = (ClassLoader)map.get(string);
        if (classLoader != null) {
            list.add(classLoader);
        }
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T> Class<T> classForName(String string) {
        try {
            return Class.forName(string, true, this.aggregatedClassLoader);
        }
        catch (Exception exception) {
            throw new ClassLoadingException("Unable to load class [" + string + "]", exception);
        }
    }

    @Override
    public URL locateResource(String string) {
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            try {
                return this.aggregatedClassLoader.getResource(string);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    @Override
    public InputStream locateResourceStream(String string) {
        try {
            log.tracef("trying via [new URL(\"%s\")]", (Object)string);
            return new URL(string).openStream();
        }
        catch (Exception exception) {
            InputStream inputStream;
            try {
                log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", (Object)string);
                inputStream = this.aggregatedClassLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            InputStream inputStream2 = inputStream = string.startsWith("/") ? string.substring(1) : null;
            if (inputStream != null) {
                try {
                    log.tracef("trying via [new URL(\"%s\")]", (Object)inputStream);
                    return new URL((String)((Object)inputStream)).openStream();
                }
                catch (Exception exception3) {
                    try {
                        log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", (Object)inputStream);
                        InputStream inputStream3 = this.aggregatedClassLoader.getResourceAsStream((String)((Object)inputStream));
                        if (inputStream3 != null) {
                            return inputStream3;
                        }
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    @Override
    public List<URL> locateResources(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = this.aggregatedClassLoader.getResources(string);
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public <S> LinkedHashSet<S> loadJavaServices(Class<S> clazz) {
        ServiceLoader<S> serviceLoader = ServiceLoader.load(clazz, this.aggregatedClassLoader);
        LinkedHashSet<S> linkedHashSet = new LinkedHashSet<S>();
        for (S s : serviceLoader) {
            linkedHashSet.add(s);
        }
        return linkedHashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AggregatedClassLoader
    extends ClassLoader {
        private final ClassLoader[] individualClassLoaders;

        private AggregatedClassLoader(LinkedHashSet<ClassLoader> linkedHashSet) {
            super(null);
            this.individualClassLoaders = linkedHashSet.toArray(new ClassLoader[linkedHashSet.size()]);
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            final HashSet<URL> hashSet = new HashSet<URL>();
            for (ClassLoader classLoader : this.individualClassLoaders) {
                Enumeration<URL> enumeration = classLoader.getResources(string);
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
            }
            return new Enumeration<URL>(){
                final Iterator<URL> resourceUrlIterator;
                {
                    this.resourceUrlIterator = hashSet.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.resourceUrlIterator.hasNext();
                }

                @Override
                public URL nextElement() {
                    return this.resourceUrlIterator.next();
                }
            };
        }

        @Override
        protected URL findResource(String string) {
            for (ClassLoader classLoader : this.individualClassLoaders) {
                URL uRL = classLoader.getResource(string);
                if (uRL == null) continue;
                return uRL;
            }
            return super.findResource(string);
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            for (ClassLoader classLoader : this.individualClassLoaders) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (Exception exception) {
                }
            }
            throw new ClassNotFoundException("Could not load requested class : " + string);
        }
    }
}

