/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.SourceType;
import org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.StandardServiceInitiators;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.BootstrapServiceRegistryImpl;
import org.hibernate.service.internal.JaxbProcessor;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistryBuilder {
    private static final Logger log = Logger.getLogger(ServiceRegistryBuilder.class);
    public static final String DEFAULT_CFG_RESOURCE_NAME = "hibernate.cfg.xml";
    private final Map settings;
    private final List<BasicServiceInitiator> initiators = ServiceRegistryBuilder.standardInitiatorList();
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private ValueHolder<JaxbProcessor> jaxbProcessorHolder = new ValueHolder<1>(new ValueHolder.DeferredInitializer<JaxbProcessor>(){

        @Override
        public JaxbProcessor initialize() {
            return new JaxbProcessor(ServiceRegistryBuilder.this.bootstrapServiceRegistry.getService(ClassLoaderService.class));
        }
    });

    public ServiceRegistryBuilder() {
        this(new BootstrapServiceRegistryImpl());
    }

    public ServiceRegistryBuilder(BootstrapServiceRegistry bootstrapServiceRegistry) {
        this.settings = Environment.getProperties();
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
    }

    private static List<BasicServiceInitiator> standardInitiatorList() {
        ArrayList<BasicServiceInitiator> arrayList = new ArrayList<BasicServiceInitiator>();
        arrayList.addAll(StandardServiceInitiators.LIST);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceRegistryBuilder loadProperties(String string) {
        InputStream inputStream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(string);
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.settings.putAll(properties);
        }
        catch (IOException iOException) {
            try {
                throw new ConfigurationException("Unable to apply settings from properties file [" + string + "]", iOException);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    log.debug((Object)String.format("Unable to close properties file [%s] stream", string), iOException2);
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return this;
        }
        catch (IOException iOException) {
            log.debug((Object)String.format("Unable to close properties file [%s] stream", string), iOException);
            return this;
        }
    }

    public ServiceRegistryBuilder configure() {
        return this.configure(DEFAULT_CFG_RESOURCE_NAME);
    }

    public ServiceRegistryBuilder configure(String string) {
        InputStream inputStream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(string);
        JaxbHibernateConfiguration jaxbHibernateConfiguration = this.jaxbProcessorHolder.getValue().unmarshal(inputStream, new Origin(SourceType.RESOURCE, string));
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbProperty jaxbProperty : jaxbHibernateConfiguration.getSessionFactory().getProperty()) {
            this.settings.put(jaxbProperty.getName(), jaxbProperty.getValue());
        }
        return this;
    }

    public ServiceRegistryBuilder applySetting(String string, Object object) {
        this.settings.put(string, object);
        return this;
    }

    public ServiceRegistryBuilder applySettings(Map map) {
        this.settings.putAll(map);
        return this;
    }

    public ServiceRegistryBuilder addInitiator(BasicServiceInitiator basicServiceInitiator) {
        this.initiators.add(basicServiceInitiator);
        return this;
    }

    public ServiceRegistryBuilder addService(Class clazz, Service service) {
        this.providedServices.add(new ProvidedService<Service>(clazz, service));
        return this;
    }

    public ServiceRegistry buildServiceRegistry() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.settings);
        Environment.verifyProperties(hashMap);
        ConfigurationHelper.resolvePlaceHolders(hashMap);
        for (Integrator integrator : this.bootstrapServiceRegistry.getService(IntegratorService.class).getIntegrators()) {
            if (!ServiceContributingIntegrator.class.isInstance(integrator)) continue;
            ((ServiceContributingIntegrator)ServiceContributingIntegrator.class.cast(integrator)).prepareServices(this);
        }
        return new StandardServiceRegistryImpl(this.bootstrapServiceRegistry, this.initiators, this.providedServices, hashMap);
    }

    public static void destroy(ServiceRegistry serviceRegistry) {
        ((StandardServiceRegistryImpl)serviceRegistry).destroy();
    }
}

