/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure.internal;

import java.security.Permission;

public class HibernatePermission
extends Permission {
    public static final String INSERT = "insert";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    public static final String READ = "read";
    public static final String ANY = "*";
    private final String actions;

    public HibernatePermission(String string, String string2) {
        super(string);
        this.actions = string2;
    }

    public boolean implies(Permission permission) {
        return !(!ANY.equals(this.getName()) && !this.getName().equals(permission.getName()) || !ANY.equals(this.actions) && this.actions.indexOf(permission.getActions()) < 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HibernatePermission)) {
            return false;
        }
        HibernatePermission hibernatePermission = (HibernatePermission)object;
        return hibernatePermission.getName().equals(this.getName()) && hibernatePermission.getActions().equals(this.actions);
    }

    public int hashCode() {
        return this.getName().hashCode() * 37 + this.actions.hashCode();
    }

    public String getActions() {
        return this.actions;
    }

    public String toString() {
        return "HibernatePermission(" + this.getName() + ':' + this.actions + ')';
    }
}

