/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.javassist;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.javassist.SerializableProxy;
import org.hibernate.type.CompositeType;
import org.jboss.logging.Logger;

public class JavassistLazyInitializer
extends BasicLazyInitializer
implements MethodHandler {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JavassistLazyInitializer.class.getName());
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method method) {
            return method.getParameterTypes().length != 0 || !method.getName().equals("finalize");
        }
    };
    private Class[] interfaces;
    private boolean constructed = false;

    private JavassistLazyInitializer(String string, Class clazz, Class[] classArray, Serializable serializable, Method method, Method method2, CompositeType compositeType, SessionImplementor sessionImplementor, boolean bl) {
        super(string, clazz, serializable, method, method2, compositeType, sessionImplementor, bl);
        this.interfaces = classArray;
    }

    public static HibernateProxy getProxy(String string, Class clazz, Class[] classArray, Method method, Method method2, CompositeType compositeType, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        try {
            JavassistLazyInitializer javassistLazyInitializer = new JavassistLazyInitializer(string, clazz, classArray, serializable, method, method2, compositeType, sessionImplementor, ReflectHelper.overridesEquals(clazz));
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(classArray.length == 1 ? clazz : null);
            proxyFactory.setInterfaces(classArray);
            proxyFactory.setFilter(FINALIZE_FILTER);
            Class clazz2 = proxyFactory.createClass();
            HibernateProxy hibernateProxy = (HibernateProxy)clazz2.newInstance();
            ((ProxyObject)hibernateProxy).setHandler((MethodHandler)javassistLazyInitializer);
            javassistLazyInitializer.constructed = true;
            return hibernateProxy;
        }
        catch (Throwable throwable) {
            LOG.error(LOG.javassistEnhancementFailed(string), throwable);
            throw new HibernateException(LOG.javassistEnhancementFailed(string), throwable);
        }
    }

    public static HibernateProxy getProxy(Class clazz, String string, Class clazz2, Class[] classArray, Method method, Method method2, CompositeType compositeType, Serializable serializable, SessionImplementor sessionImplementor, boolean bl) throws HibernateException {
        HibernateProxy hibernateProxy;
        JavassistLazyInitializer javassistLazyInitializer = new JavassistLazyInitializer(string, clazz2, classArray, serializable, method, method2, compositeType, sessionImplementor, bl);
        try {
            hibernateProxy = (HibernateProxy)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("Javassist Enhancement failed: " + clazz2.getName(), exception);
        }
        ((ProxyObject)hibernateProxy).setHandler((MethodHandler)javassistLazyInitializer);
        javassistLazyInitializer.constructed = true;
        return hibernateProxy;
    }

    public static Class getProxyFactory(Class clazz, Class[] classArray) throws HibernateException {
        try {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(classArray.length == 1 ? clazz : null);
            proxyFactory.setInterfaces(classArray);
            proxyFactory.setFilter(FINALIZE_FILTER);
            return proxyFactory.createClass();
        }
        catch (Throwable throwable) {
            LOG.error(LOG.javassistEnhancementFailed(clazz.getName()), throwable);
            throw new HibernateException(LOG.javassistEnhancementFailed(clazz.getName()), throwable);
        }
    }

    public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Throwable {
        if (this.constructed) {
            Object object2;
            try {
                object2 = this.invoke(method, objectArray, object);
            }
            catch (Throwable throwable) {
                throw new Exception(throwable.getCause());
            }
            if (object2 == INVOKE_IMPLEMENTATION) {
                Object object3 = this.getImplementation();
                try {
                    Object object4;
                    if (ReflectHelper.isPublic(this.persistentClass, method)) {
                        if (!method.getDeclaringClass().isInstance(object3)) {
                            throw new ClassCastException(object3.getClass().getName());
                        }
                        object4 = method.invoke(object3, objectArray);
                    } else {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        object4 = method.invoke(object3, objectArray);
                    }
                    if (object4 == object3) {
                        if (object4.getClass().isInstance(object)) {
                            return object;
                        }
                        LOG.narrowingProxy(object4.getClass());
                    }
                    return object4;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            return object2;
        }
        if (method.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        return method2.invoke(object, objectArray);
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.isReadOnlySettingAvailable() ? Boolean.valueOf(this.isReadOnly()) : this.isReadOnlyBeforeAttachedToSession(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

