/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.EmbeddedPropertyAccessor;
import org.hibernate.property.MapAccessor;
import org.hibernate.property.NoopAccessor;
import org.hibernate.property.PropertyAccessor;

public final class PropertyAccessorFactory {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
    private static final PropertyAccessor MAP_ACCESSOR = new MapAccessor();
    private static final PropertyAccessor NOOP_ACCESSOR = new NoopAccessor();
    private static final PropertyAccessor EMBEDDED_PROPERTY_ACCESSOR = new EmbeddedPropertyAccessor();

    public static PropertyAccessor getPropertyAccessor(Property property, EntityMode entityMode) throws MappingException {
        if (null == entityMode || EntityMode.POJO.equals((Object)entityMode)) {
            return PropertyAccessorFactory.getPojoPropertyAccessor(property.getPropertyAccessorName());
        }
        if (EntityMode.MAP.equals((Object)entityMode)) {
            return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
        }
        throw new MappingException("Unknown entity mode [" + (Object)((Object)entityMode) + "]");
    }

    public static PropertyAccessor getPropertyAccessor(AttributeBinding attributeBinding, EntityMode entityMode) throws MappingException {
        if (null == entityMode || EntityMode.POJO.equals((Object)entityMode)) {
            return PropertyAccessorFactory.getPojoPropertyAccessor(attributeBinding.getPropertyAccessorName());
        }
        if (EntityMode.MAP.equals((Object)entityMode)) {
            return PropertyAccessorFactory.getDynamicMapPropertyAccessor();
        }
        throw new MappingException("Unknown entity mode [" + (Object)((Object)entityMode) + "]");
    }

    private static PropertyAccessor getPojoPropertyAccessor(String string) {
        if (StringHelper.isEmpty(string) || "property".equals(string)) {
            return BASIC_PROPERTY_ACCESSOR;
        }
        if ("field".equals(string)) {
            return DIRECT_PROPERTY_ACCESSOR;
        }
        if ("embedded".equals(string)) {
            return EMBEDDED_PROPERTY_ACCESSOR;
        }
        if ("noop".equals(string)) {
            return NOOP_ACCESSOR;
        }
        return PropertyAccessorFactory.resolveCustomAccessor(string);
    }

    public static PropertyAccessor getDynamicMapPropertyAccessor() throws MappingException {
        return MAP_ACCESSOR;
    }

    private static PropertyAccessor resolveCustomAccessor(String string) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("could not find PropertyAccessor class: " + string, classNotFoundException);
        }
        try {
            return (PropertyAccessor)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new MappingException("could not instantiate PropertyAccessor class: " + string, exception);
        }
    }

    private PropertyAccessorFactory() {
    }

    public static PropertyAccessor getPropertyAccessor(Class clazz, String string) throws MappingException {
        if (string == null) {
            string = clazz == null || clazz == Map.class ? "map" : "property";
        }
        return PropertyAccessorFactory.getPropertyAccessor(string);
    }

    public static PropertyAccessor getPropertyAccessor(String string) throws MappingException {
        if (string == null || "property".equals(string)) {
            return BASIC_PROPERTY_ACCESSOR;
        }
        if ("field".equals(string)) {
            return DIRECT_PROPERTY_ACCESSOR;
        }
        if ("map".equals(string)) {
            return MAP_ACCESSOR;
        }
        if ("embedded".equals(string)) {
            return EMBEDDED_PROPERTY_ACCESSOR;
        }
        if ("noop".equals(string)) {
            return NOOP_ACCESSOR;
        }
        return PropertyAccessorFactory.resolveCustomAccessor(string);
    }
}

