/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.jboss.logging.Logger;

public class BasicPropertyAccessor
implements PropertyAccessor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BasicPropertyAccessor.class.getName());

    public Setter getSetter(Class clazz, String string) throws PropertyNotFoundException {
        return BasicPropertyAccessor.createSetter(clazz, string);
    }

    private static Setter createSetter(Class clazz, String string) throws PropertyNotFoundException {
        BasicSetter basicSetter = BasicPropertyAccessor.getSetterOrNull(clazz, string);
        if (basicSetter == null) {
            throw new PropertyNotFoundException("Could not find a setter for property " + string + " in class " + clazz.getName());
        }
        return basicSetter;
    }

    private static BasicSetter getSetterOrNull(Class clazz, String string) {
        if (clazz == Object.class || clazz == null) {
            return null;
        }
        Method method = BasicPropertyAccessor.setterMethod(clazz, string);
        if (method != null) {
            if (!ReflectHelper.isPublic(clazz, method)) {
                method.setAccessible(true);
            }
            return new BasicSetter(clazz, method, string);
        }
        BasicSetter basicSetter = BasicPropertyAccessor.getSetterOrNull(clazz.getSuperclass(), string);
        if (basicSetter == null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; basicSetter == null && i < classArray.length; ++i) {
                basicSetter = BasicPropertyAccessor.getSetterOrNull(classArray[i], string);
            }
        }
        return basicSetter;
    }

    private static Method setterMethod(Class clazz, String string) {
        BasicGetter basicGetter = BasicPropertyAccessor.getGetterOrNull(clazz, string);
        Class clazz2 = basicGetter == null ? null : basicGetter.getReturnType();
        Method[] methodArray = clazz.getDeclaredMethods();
        Method method = null;
        for (Method method2 : methodArray) {
            String string2 = method2.getName();
            if (method2.getParameterTypes().length != 1 || !string2.startsWith("set")) continue;
            String string3 = Introspector.decapitalize(string2.substring(3));
            String string4 = string2.substring(3);
            if (!string3.equals(string) && !string4.equals(string)) continue;
            method = method2;
            if (clazz2 != null && !method2.getParameterTypes()[0].equals(clazz2)) continue;
            return method;
        }
        return method;
    }

    public Getter getGetter(Class clazz, String string) throws PropertyNotFoundException {
        return BasicPropertyAccessor.createGetter(clazz, string);
    }

    public static Getter createGetter(Class clazz, String string) throws PropertyNotFoundException {
        BasicGetter basicGetter = BasicPropertyAccessor.getGetterOrNull(clazz, string);
        if (basicGetter == null) {
            throw new PropertyNotFoundException("Could not find a getter for " + string + " in class " + clazz.getName());
        }
        return basicGetter;
    }

    private static BasicGetter getGetterOrNull(Class clazz, String string) {
        if (clazz == Object.class || clazz == null) {
            return null;
        }
        Method method = BasicPropertyAccessor.getterMethod(clazz, string);
        if (method != null) {
            if (!ReflectHelper.isPublic(clazz, method)) {
                method.setAccessible(true);
            }
            return new BasicGetter(clazz, method, string);
        }
        BasicGetter basicGetter = BasicPropertyAccessor.getGetterOrNull(clazz.getSuperclass(), string);
        if (basicGetter == null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; basicGetter == null && i < classArray.length; ++i) {
                basicGetter = BasicPropertyAccessor.getGetterOrNull(classArray[i], string);
            }
        }
        return basicGetter;
    }

    private static Method getterMethod(Class clazz, String string) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            String string2;
            String string3;
            if (method.getParameterTypes().length != 0 || method.isBridge()) continue;
            String string4 = method.getName();
            if (string4.startsWith("get")) {
                string3 = Introspector.decapitalize(string4.substring(3));
                string2 = string4.substring(3);
                if (string3.equals(string) || string2.equals(string)) {
                    return method;
                }
            }
            if (!string4.startsWith("is")) continue;
            string3 = Introspector.decapitalize(string4.substring(2));
            string2 = string4.substring(2);
            if (!string3.equals(string) && !string2.equals(string)) continue;
            return method;
        }
        return null;
    }

    public static final class BasicGetter
    implements Getter {
        private Class clazz;
        private final transient Method method;
        private final String propertyName;

        private BasicGetter(Class clazz, Method method, String string) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = string;
        }

        public Object get(Object object) throws HibernateException {
            try {
                return this.method.invoke(object, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new PropertyAccessException(invocationTargetException, "Exception occurred inside", false, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PropertyAccessException(illegalAccessException, "IllegalAccessException occurred while calling", false, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.illegalPropertyGetterArgument(this.clazz.getName(), this.propertyName);
                throw new PropertyAccessException(illegalArgumentException, "IllegalArgumentException occurred calling", false, this.clazz, this.propertyName);
            }
        }

        public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) {
            return this.get(object);
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }

        public Member getMember() {
            return this.method;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public String toString() {
            return "BasicGetter(" + this.clazz.getName() + '.' + this.propertyName + ')';
        }

        Object readResolve() {
            return BasicPropertyAccessor.createGetter(this.clazz, this.propertyName);
        }
    }

    public static final class BasicSetter
    implements Setter {
        private Class clazz;
        private final transient Method method;
        private final String propertyName;

        private BasicSetter(Class clazz, Method method, String string) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = string;
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            try {
                this.method.invoke(object, object2);
            }
            catch (NullPointerException nullPointerException) {
                if (object2 == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(nullPointerException, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(nullPointerException, "NullPointerException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new PropertyAccessException(invocationTargetException, "Exception occurred inside", true, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PropertyAccessException(illegalAccessException, "IllegalAccessException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(illegalArgumentException, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                LOG.illegalPropertySetterArgument(this.clazz.getName(), this.propertyName);
                LOG.expectedType(this.method.getParameterTypes()[0].getName(), object2 == null ? null : object2.getClass().getName());
                throw new PropertyAccessException(illegalArgumentException, "IllegalArgumentException occurred while calling", true, this.clazz, this.propertyName);
            }
        }

        public Method getMethod() {
            return this.method;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        Object readResolve() {
            return BasicPropertyAccessor.createSetter(this.clazz, this.propertyName);
        }

        public String toString() {
            return "BasicSetter(" + this.clazz.getName() + '.' + this.propertyName + ')';
        }
    }
}

