/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.io.Serializable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String infoString(String string, Serializable serializable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (string == null) {
            stringBuilder.append("<null entity name>");
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append('#');
        if (serializable == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append(serializable);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String infoString(EntityPersister entityPersister, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Type type;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (entityPersister == null) {
            stringBuilder.append("<null EntityPersister>");
            type = null;
        } else {
            stringBuilder.append(entityPersister.getEntityName());
            type = entityPersister.getIdentifierType();
        }
        stringBuilder.append('#');
        if (object == null) {
            stringBuilder.append("<null>");
        } else if (type == null) {
            stringBuilder.append(object);
        } else {
            stringBuilder.append(type.toLoggableString(object, sessionFactoryImplementor));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String infoString(EntityPersister entityPersister, Object object, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (entityPersister == null) {
            stringBuilder.append("<null EntityPersister>");
        } else {
            stringBuilder.append(entityPersister.getEntityName());
        }
        stringBuilder.append('#');
        if (object == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append(type.toLoggableString(object, sessionFactoryImplementor));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String infoString(EntityPersister entityPersister, Serializable[] serializableArray, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (entityPersister == null) {
            stringBuilder.append("<null EntityPersister>");
        } else {
            stringBuilder.append(entityPersister.getEntityName());
            stringBuilder.append("#<");
            for (int i = 0; i < serializableArray.length; ++i) {
                stringBuilder.append(entityPersister.getIdentifierType().toLoggableString(serializableArray[i], sessionFactoryImplementor));
                if (i >= serializableArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append('>');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String infoString(EntityPersister entityPersister) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (entityPersister == null) {
            stringBuilder.append("<null EntityPersister>");
        } else {
            stringBuilder.append(entityPersister.getEntityName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String infoString(String string, String string2, Object object) {
        StringBuilder stringBuilder = new StringBuilder().append('[').append(string).append('.').append(string2).append('#');
        if (object == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append(object);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String collectionInfoString(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (collectionPersister == null) {
            stringBuilder.append("<unreferenced>");
        } else {
            stringBuilder.append(collectionPersister.getRole());
            stringBuilder.append('#');
            Type type = collectionPersister.getOwnerEntityPersister().getIdentifierType();
            Serializable serializable2 = serializable.getClass().isAssignableFrom(type.getReturnedClass()) ? serializable : sessionImplementor.getPersistenceContext().getEntry(persistentCollection.getOwner()).getId();
            stringBuilder.append(type.toLoggableString(serializable2, sessionImplementor.getFactory()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String collectionInfoString(CollectionPersister collectionPersister, Serializable[] serializableArray, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (collectionPersister == null) {
            stringBuilder.append("<unreferenced>");
        } else {
            stringBuilder.append(collectionPersister.getRole());
            stringBuilder.append("#<");
            for (int i = 0; i < serializableArray.length; ++i) {
                MessageHelper.addIdToCollectionInfoString(collectionPersister, serializableArray[i], sessionFactoryImplementor, stringBuilder);
                if (i >= serializableArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append('>');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String collectionInfoString(CollectionPersister collectionPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (collectionPersister == null) {
            stringBuilder.append("<unreferenced>");
        } else {
            stringBuilder.append(collectionPersister.getRole());
            stringBuilder.append('#');
            if (serializable == null) {
                stringBuilder.append("<null>");
            } else {
                MessageHelper.addIdToCollectionInfoString(collectionPersister, serializable, sessionFactoryImplementor, stringBuilder);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static void addIdToCollectionInfoString(CollectionPersister collectionPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor, StringBuilder stringBuilder) {
        Type type = collectionPersister.getOwnerEntityPersister().getIdentifierType();
        if (serializable.getClass().isAssignableFrom(type.getReturnedClass())) {
            stringBuilder.append(type.toLoggableString(serializable, sessionFactoryImplementor));
        } else {
            stringBuilder.append(serializable.toString());
        }
    }

    public static String collectionInfoString(String string, Serializable serializable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (string == null) {
            stringBuilder.append("<unreferenced>");
        } else {
            stringBuilder.append(string);
            stringBuilder.append('#');
            if (serializable == null) {
                stringBuilder.append("<null>");
            } else {
                stringBuilder.append(serializable);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

