/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.Iterator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.UnknownPersisterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPersisterClassResolver
implements PersisterClassResolver {
    @Override
    public Class<? extends EntityPersister> getEntityPersisterClass(EntityBinding entityBinding) {
        if (entityBinding.isRoot()) {
            Iterator<EntityBinding> iterator = entityBinding.getDirectSubEntityBindings().iterator();
            if (iterator.hasNext()) {
                entityBinding = iterator.next();
            } else {
                return this.singleTableEntityPersister();
            }
        }
        switch (entityBinding.getHierarchyDetails().getInheritanceType()) {
            case JOINED: {
                return this.joinedSubclassEntityPersister();
            }
            case SINGLE_TABLE: {
                return this.singleTableEntityPersister();
            }
            case TABLE_PER_CLASS: {
                return this.unionSubclassEntityPersister();
            }
        }
        throw new UnknownPersisterException("Could not determine persister implementation for entity [" + entityBinding.getEntity().getName() + "]");
    }

    @Override
    public Class<? extends EntityPersister> getEntityPersisterClass(PersistentClass persistentClass) {
        if (RootClass.class.isInstance(persistentClass)) {
            if (persistentClass.hasSubclasses()) {
                persistentClass = (PersistentClass)persistentClass.getDirectSubclasses().next();
            } else {
                return this.singleTableEntityPersister();
            }
        }
        if (JoinedSubclass.class.isInstance(persistentClass)) {
            return this.joinedSubclassEntityPersister();
        }
        if (UnionSubclass.class.isInstance(persistentClass)) {
            return this.unionSubclassEntityPersister();
        }
        if (SingleTableSubclass.class.isInstance(persistentClass)) {
            return this.singleTableEntityPersister();
        }
        throw new UnknownPersisterException("Could not determine persister implementation for entity [" + persistentClass.getEntityName() + "]");
    }

    public Class<? extends EntityPersister> singleTableEntityPersister() {
        return SingleTableEntityPersister.class;
    }

    public Class<? extends EntityPersister> joinedSubclassEntityPersister() {
        return JoinedSubclassEntityPersister.class;
    }

    public Class<? extends EntityPersister> unionSubclassEntityPersister() {
        return UnionSubclassEntityPersister.class;
    }

    @Override
    public Class<? extends CollectionPersister> getCollectionPersisterClass(Collection collection) {
        return collection.isOneToMany() ? this.oneToManyPersister() : this.basicCollectionPersister();
    }

    @Override
    public Class<? extends CollectionPersister> getCollectionPersisterClass(PluralAttributeBinding pluralAttributeBinding) {
        return pluralAttributeBinding.getCollectionElement().getCollectionElementNature() == CollectionElementNature.ONE_TO_MANY ? this.oneToManyPersister() : this.basicCollectionPersister();
    }

    private Class<OneToManyPersister> oneToManyPersister() {
        return OneToManyPersister.class;
    }

    private Class<BasicCollectionPersister> basicCollectionPersister() {
        return BasicCollectionPersister.class;
    }
}

