/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.Map;
import org.hibernate.persister.internal.PersisterFactoryImpl;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersisterFactoryInitiator
implements BasicServiceInitiator<PersisterFactory> {
    public static final PersisterFactoryInitiator INSTANCE = new PersisterFactoryInitiator();
    public static final String IMPL_NAME = "hibernate.persister.factory";

    @Override
    public Class<PersisterFactory> getServiceInitiated() {
        return PersisterFactory.class;
    }

    @Override
    public PersisterFactory initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = map.get(IMPL_NAME);
        if (v == null) {
            return new PersisterFactoryImpl();
        }
        if (PersisterFactory.class.isInstance(v)) {
            return (PersisterFactory)v;
        }
        Class<? extends PersisterFactory> clazz = Class.class.isInstance(v) ? (Class<? extends PersisterFactory>)v : this.locate(serviceRegistryImplementor, v.toString());
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Could not initialize custom PersisterFactory impl [" + clazz.getName() + "]", exception);
        }
    }

    private Class<? extends PersisterFactory> locate(ServiceRegistryImplementor serviceRegistryImplementor, String string) {
        return serviceRegistryImplementor.getService(ClassLoaderService.class).classForName(string);
    }
}

