/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersisterFactoryImpl
implements PersisterFactory,
ServiceRegistryAwareService {
    public static final Class[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityRegionAccessStrategy.class, NaturalIdRegionAccessStrategy.class, SessionFactoryImplementor.class, Mapping.class};
    public static final Class[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS_NEW = new Class[]{EntityBinding.class, EntityRegionAccessStrategy.class, NaturalIdRegionAccessStrategy.class, SessionFactoryImplementor.class, Mapping.class};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionRegionAccessStrategy.class, Configuration.class, SessionFactoryImplementor.class};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS_NEW = new Class[]{AbstractPluralAttributeBinding.class, CollectionRegionAccessStrategy.class, MetadataImplementor.class, SessionFactoryImplementor.class};
    private ServiceRegistryImplementor serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.serviceRegistry = serviceRegistryImplementor;
    }

    @Override
    public EntityPersister createEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) {
        Class<? extends EntityPersister> clazz = persistentClass.getEntityPersisterClass();
        if (clazz == null) {
            clazz = this.serviceRegistry.getService(PersisterClassResolver.class).getEntityPersisterClass(persistentClass);
        }
        return PersisterFactoryImpl.create(clazz, ENTITY_PERSISTER_CONSTRUCTOR_ARGS, persistentClass, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor, mapping);
    }

    @Override
    public EntityPersister createEntityPersister(EntityBinding entityBinding, EntityRegionAccessStrategy entityRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) {
        Class<? extends EntityPersister> clazz = entityBinding.getCustomEntityPersisterClass();
        if (clazz == null) {
            clazz = this.serviceRegistry.getService(PersisterClassResolver.class).getEntityPersisterClass(entityBinding);
        }
        return PersisterFactoryImpl.create(clazz, ENTITY_PERSISTER_CONSTRUCTOR_ARGS_NEW, entityBinding, entityRegionAccessStrategy, null, sessionFactoryImplementor, mapping);
    }

    private static EntityPersister create(Class<? extends EntityPersister> clazz, Class[] classArray, Object object, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        try {
            Constructor<? extends EntityPersister> constructor = clazz.getConstructor(classArray);
            try {
                return constructor.newInstance(object, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor, mapping);
            }
            catch (MappingException mappingException) {
                throw mappingException;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof HibernateException) {
                    throw (HibernateException)throwable;
                }
                throw new MappingException("Could not instantiate persister " + clazz.getName(), throwable);
            }
            catch (Exception exception) {
                throw new MappingException("Could not instantiate persister " + clazz.getName(), exception);
            }
        }
        catch (MappingException mappingException) {
            throw mappingException;
        }
        catch (Exception exception) {
            throw new MappingException("Could not get constructor for " + clazz.getName(), exception);
        }
    }

    @Override
    public CollectionPersister createCollectionPersister(Configuration configuration, Collection collection, CollectionRegionAccessStrategy collectionRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Class<? extends CollectionPersister> clazz = collection.getCollectionPersisterClass();
        if (clazz == null) {
            clazz = this.serviceRegistry.getService(PersisterClassResolver.class).getCollectionPersisterClass(collection);
        }
        return PersisterFactoryImpl.create(clazz, COLLECTION_PERSISTER_CONSTRUCTOR_ARGS, configuration, collection, collectionRegionAccessStrategy, sessionFactoryImplementor);
    }

    @Override
    public CollectionPersister createCollectionPersister(MetadataImplementor metadataImplementor, PluralAttributeBinding pluralAttributeBinding, CollectionRegionAccessStrategy collectionRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Class<? extends CollectionPersister> clazz = pluralAttributeBinding.getCollectionPersisterClass();
        if (clazz == null) {
            clazz = this.serviceRegistry.getService(PersisterClassResolver.class).getCollectionPersisterClass(pluralAttributeBinding);
        }
        return PersisterFactoryImpl.create(clazz, COLLECTION_PERSISTER_CONSTRUCTOR_ARGS_NEW, metadataImplementor, pluralAttributeBinding, collectionRegionAccessStrategy, sessionFactoryImplementor);
    }

    private static CollectionPersister create(Class<? extends CollectionPersister> clazz, Class[] classArray, Object object, Object object2, CollectionRegionAccessStrategy collectionRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        try {
            Constructor<? extends CollectionPersister> constructor = clazz.getConstructor(classArray);
            try {
                return constructor.newInstance(object2, collectionRegionAccessStrategy, object, sessionFactoryImplementor);
            }
            catch (MappingException mappingException) {
                throw mappingException;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof HibernateException) {
                    throw (HibernateException)throwable;
                }
                throw new MappingException("Could not instantiate collection persister " + clazz.getName(), throwable);
            }
            catch (Exception exception) {
                throw new MappingException("Could not instantiate collection persister " + clazz.getName(), exception);
            }
        }
        catch (MappingException mappingException) {
            throw mappingException;
        }
        catch (Exception exception) {
            throw new MappingException("Could not get constructor for " + clazz.getName(), exception);
        }
    }
}

