/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.Map;
import org.hibernate.persister.internal.StandardPersisterClassResolver;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersisterClassResolverInitiator
implements BasicServiceInitiator<PersisterClassResolver> {
    public static final PersisterClassResolverInitiator INSTANCE = new PersisterClassResolverInitiator();
    public static final String IMPL_NAME = "hibernate.persister.resolver";

    @Override
    public Class<PersisterClassResolver> getServiceInitiated() {
        return PersisterClassResolver.class;
    }

    @Override
    public PersisterClassResolver initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = map.get(IMPL_NAME);
        if (v == null) {
            return new StandardPersisterClassResolver();
        }
        if (PersisterClassResolver.class.isInstance(v)) {
            return (PersisterClassResolver)v;
        }
        Class<? extends PersisterClassResolver> clazz = Class.class.isInstance(v) ? (Class<? extends PersisterClassResolver>)v : this.locate(serviceRegistryImplementor, v.toString());
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Could not initialize custom PersisterClassResolver impl [" + clazz.getName() + "]", exception);
        }
    }

    private Class<? extends PersisterClassResolver> locate(ServiceRegistryImplementor serviceRegistryImplementor, String string) {
        return serviceRegistryImplementor.getService(ClassLoaderService.class).classForName(string);
    }
}

