/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class UnionSubclassEntityPersister
extends AbstractEntityPersister {
    private final String subquery;
    private final String tableName;
    private final String[] subclassClosure;
    private final String[] spaces;
    private final String[] subclassSpaces;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final Map subclassByDiscriminatorValue = new HashMap();
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;

    public UnionSubclassEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(persistentClass, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        if (this.getIdentifierGenerator() instanceof IdentityGenerator) {
            throw new MappingException("Cannot use identity column key generation with <union-subclass> mapping for: " + this.getEntityName());
        }
        this.tableName = persistentClass.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
        boolean bl = false;
        ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = null;
        String string = persistentClass.getCustomSQLInsert();
        boolean bl2 = bl = string != null && persistentClass.isCustomInsertCallable();
        executeUpdateResultCheckStyle = string == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(string, bl) : persistentClass.getCustomSQLInsertCheckStyle());
        this.customSQLInsert = new String[]{string};
        this.insertCallable = new boolean[]{bl};
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{executeUpdateResultCheckStyle};
        string = persistentClass.getCustomSQLUpdate();
        boolean bl3 = bl = string != null && persistentClass.isCustomUpdateCallable();
        executeUpdateResultCheckStyle = string == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(string, bl) : persistentClass.getCustomSQLUpdateCheckStyle());
        this.customSQLUpdate = new String[]{string};
        this.updateCallable = new boolean[]{bl};
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{executeUpdateResultCheckStyle};
        string = persistentClass.getCustomSQLDelete();
        boolean bl4 = bl = string != null && persistentClass.isCustomDeleteCallable();
        executeUpdateResultCheckStyle = string == null ? ExecuteUpdateResultCheckStyle.COUNT : (persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(string, bl) : persistentClass.getCustomSQLDeleteCheckStyle());
        this.customSQLDelete = new String[]{string};
        this.deleteCallable = new boolean[]{bl};
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[]{executeUpdateResultCheckStyle};
        this.discriminatorValue = persistentClass.getSubclassId();
        this.discriminatorSQLValue = String.valueOf(persistentClass.getSubclassId());
        int n = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[n];
        this.subclassClosure[0] = this.getEntityName();
        this.subclassByDiscriminatorValue.put(persistentClass.getSubclassId(), persistentClass.getEntityName());
        if (persistentClass.isPolymorphic()) {
            Iterator iterator = persistentClass.getSubclassIterator();
            int n2 = 1;
            while (iterator.hasNext()) {
                Subclass subclass = (Subclass)iterator.next();
                this.subclassClosure[n2++] = subclass.getEntityName();
                this.subclassByDiscriminatorValue.put(subclass.getSubclassId(), subclass.getEntityName());
            }
        }
        int n3 = 1 + persistentClass.getSynchronizedTables().size();
        this.spaces = new String[n3];
        this.spaces[0] = this.tableName;
        Iterator iterator = persistentClass.getSynchronizedTables().iterator();
        for (int i = 1; i < n3; ++i) {
            this.spaces[i] = (String)iterator.next();
        }
        HashSet<String> hashSet = new HashSet<String>();
        iterator = persistentClass.getSubclassTableClosureIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            hashSet.add(table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()));
        }
        this.subclassSpaces = ArrayHelper.toStringArray(hashSet);
        this.subquery = this.generateSubquery(persistentClass, mapping);
        if (this.isMultiTable()) {
            int n4 = this.getIdentifierColumnSpan();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            if (!this.isAbstract()) {
                arrayList.add(this.tableName);
                arrayList2.add(this.getIdentifierColumnNames());
            }
            iterator = persistentClass.getSubclassTableClosureIterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (table.isAbstractUnionTable()) continue;
                String string2 = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
                arrayList.add(string2);
                String[] stringArray = new String[n4];
                Iterator iterator2 = table.getPrimaryKey().getColumnIterator();
                for (int i = 0; i < n4; ++i) {
                    stringArray[i] = ((Column)iterator2.next()).getQuotedName(sessionFactoryImplementor.getDialect());
                }
                arrayList2.add(stringArray);
            }
            this.constraintOrderedTableNames = ArrayHelper.toStringArray(arrayList);
            this.constraintOrderedKeyColumnNames = ArrayHelper.to2DStringArray(arrayList2);
        } else {
            this.constraintOrderedTableNames = new String[]{this.tableName};
            this.constraintOrderedKeyColumnNames = new String[][]{this.getIdentifierColumnNames()};
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    public UnionSubclassEntityPersister(EntityBinding entityBinding, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(entityBinding, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        this.subquery = null;
        this.tableName = null;
        this.subclassClosure = null;
        this.spaces = null;
        this.subclassSpaces = null;
        this.discriminatorValue = null;
        this.discriminatorSQLValue = null;
        this.constraintOrderedTableNames = null;
        this.constraintOrderedKeyColumnNames = null;
    }

    public Serializable[] getQuerySpaces() {
        return this.subclassSpaces;
    }

    public String getTableName() {
        return this.subquery;
    }

    public Type getDiscriminatorType() {
        return StandardBasicTypes.INTEGER;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public String getSubclassForDiscriminatorValue(Object object) {
        return (String)this.subclassByDiscriminatorValue.get(object);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected boolean isDiscriminatorFormula() {
        return false;
    }

    protected String generateSelectString(LockMode lockMode) {
        SimpleSelect simpleSelect = new SimpleSelect(this.getFactory().getDialect()).setLockMode(lockMode).setTableName(this.getTableName()).addColumns(this.getIdentifierColumnNames()).addColumns(this.getSubclassColumnClosure(), this.getSubclassColumnAliasClosure(), this.getSubclassColumnLazyiness()).addColumns(this.getSubclassFormulaClosure(), this.getSubclassFormulaAliasClosure(), this.getSubclassFormulaLazyiness());
        if (this.hasSubclasses()) {
            if (this.isDiscriminatorFormula()) {
                simpleSelect.addColumn(this.getDiscriminatorFormula(), this.getDiscriminatorAlias());
            } else {
                simpleSelect.addColumn(this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
            }
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            simpleSelect.setComment("load " + this.getEntityName());
        }
        return simpleSelect.addCondition(this.getIdentifierColumnNames(), "=?").toStatementString();
    }

    protected String getDiscriminatorFormula() {
        return null;
    }

    protected String getTableName(int n) {
        return this.tableName;
    }

    protected String[] getKeyColumns(int n) {
        return this.getIdentifierColumnNames();
    }

    protected boolean isTableCascadeDeleteEnabled(int n) {
        return false;
    }

    protected boolean isPropertyOfTable(int n, int n2) {
        return true;
    }

    public String fromTableFragment(String string) {
        return this.getTableName() + ' ' + string;
    }

    public String filterFragment(String string) {
        return this.hasWhere() ? " and " + this.getSQLWhereString(string) : "";
    }

    public String getSubclassPropertyTableName(int n) {
        return this.getTableName();
    }

    protected void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
        selectFragment.addColumn(string, this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return new int[this.getPropertySpan()];
    }

    protected int getSubclassPropertyTableNumber(int n) {
        return 0;
    }

    public int getSubclassPropertyTableNumber(String string) {
        return 0;
    }

    public boolean isMultiTable() {
        return this.isAbstract() || this.hasSubclasses();
    }

    public int getTableSpan() {
        return 1;
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return new int[this.getSubclassColumnClosure().length];
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return new int[this.getSubclassFormulaClosure().length];
    }

    protected boolean[] getTableHasColumns() {
        return new boolean[]{true};
    }

    protected int[] getPropertyTableNumbers() {
        return new int[this.getPropertySpan()];
    }

    protected String generateSubquery(PersistentClass persistentClass, Mapping mapping) {
        Iterator iterator;
        Serializable serializable;
        Dialect dialect = this.getFactory().getDialect();
        Settings settings = this.getFactory().getSettings();
        if (!persistentClass.hasSubclasses()) {
            return persistentClass.getTable().getQualifiedName(dialect, settings.getDefaultCatalogName(), settings.getDefaultSchemaName());
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator2 = persistentClass.getSubclassTableClosureIterator();
        while (iterator2.hasNext()) {
            serializable = (Table)iterator2.next();
            if (((Table)serializable).isAbstractUnionTable()) continue;
            iterator = ((Table)serializable).getColumnIterator();
            while (iterator.hasNext()) {
                linkedHashSet.add(iterator.next());
            }
        }
        serializable = new StringBuilder().append("( ");
        iterator = new JoinedIterator(new SingletonIterator(persistentClass), persistentClass.getSubclassIterator());
        while (iterator.hasNext()) {
            PersistentClass persistentClass2 = (PersistentClass)iterator.next();
            Table table = persistentClass2.getTable();
            if (table.isAbstractUnionTable()) continue;
            ((StringBuilder)serializable).append("select ");
            for (Column column : linkedHashSet) {
                if (!table.containsColumn(column)) {
                    int n = column.getSqlTypeCode(mapping);
                    ((StringBuilder)serializable).append(dialect.getSelectClauseNullString(n)).append(" as ");
                }
                ((StringBuilder)serializable).append(column.getName());
                ((StringBuilder)serializable).append(", ");
            }
            ((StringBuilder)serializable).append(persistentClass2.getSubclassId()).append(" as clazz_");
            ((StringBuilder)serializable).append(" from ").append(table.getQualifiedName(dialect, settings.getDefaultCatalogName(), settings.getDefaultSchemaName()));
            ((StringBuilder)serializable).append(" union ");
            if (!dialect.supportsUnionAll()) continue;
            ((StringBuilder)serializable).append("all ");
        }
        if (((StringBuilder)serializable).length() > 2) {
            ((StringBuilder)serializable).setLength(((StringBuilder)serializable).length() - (dialect.supportsUnionAll() ? 11 : 7));
        }
        return ((StringBuilder)serializable).append(" )").toString();
    }

    protected String[] getSubclassTableKeyColumns(int n) {
        if (n != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.getIdentifierColumnNames();
    }

    public String getSubclassTableName(int n) {
        if (n != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.tableName;
    }

    public int getSubclassTableSpan() {
        return 1;
    }

    protected boolean isClassOrSuperclassTable(int n) {
        if (n != 0) {
            throw new AssertionFailure("only one table");
        }
        return true;
    }

    public String getPropertyTableName(String string) {
        return this.getTableName();
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public FilterAliasGenerator getFilterAliasGenerator(String string) {
        return new StaticFilterAliasGenerator(string);
    }
}

