/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SimpleValueBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.Type;

public class SingleTableEntityPersister
extends AbstractEntityPersister {
    private final int joinSpan;
    private final String[] qualifiedTableNames;
    private final boolean[] isInverseTable;
    private final boolean[] isNullableTable;
    private final String[][] keyColumnNames;
    private final boolean[] cascadeDeleteEnabled;
    private final boolean hasSequentialSelects;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final boolean[] subclassTableIsLazyClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final boolean[] subclassTableSequentialSelect;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorColumnReaders;
    private final String discriminatorColumnReaderTemplate;
    private final String discriminatorFormula;
    private final String discriminatorFormulaTemplate;
    private final String discriminatorAlias;
    private final Type discriminatorType;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final Map propertyTableNumbersByNameAndSubclass = new HashMap();
    private final Map sequentialSelectStringsByEntityName = new HashMap();
    private static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    private static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");
    private static final String NULL_STRING = "null";
    private static final String NOT_NULL_STRING = "not null";

    public SingleTableEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(persistentClass, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        Object object;
        Object object2;
        Cloneable cloneable;
        Serializable serializable;
        Object object3;
        Object object4;
        Cloneable cloneable2;
        this.joinSpan = persistentClass.getJoinClosureSpan() + 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        Table table = persistentClass.getRootTable();
        this.qualifiedTableNames[0] = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.customSQLInsert[0] = persistentClass.getCustomSQLInsert();
        this.insertCallable[0] = this.customSQLInsert[0] != null && persistentClass.isCustomInsertCallable();
        this.insertResultCheckStyles[0] = persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[0], this.insertCallable[0]) : persistentClass.getCustomSQLInsertCheckStyle();
        this.customSQLUpdate[0] = persistentClass.getCustomSQLUpdate();
        this.updateCallable[0] = this.customSQLUpdate[0] != null && persistentClass.isCustomUpdateCallable();
        this.updateResultCheckStyles[0] = persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[0], this.updateCallable[0]) : persistentClass.getCustomSQLUpdateCheckStyle();
        this.customSQLDelete[0] = persistentClass.getCustomSQLDelete();
        this.deleteCallable[0] = this.customSQLDelete[0] != null && persistentClass.isCustomDeleteCallable();
        this.deleteResultCheckStyles[0] = persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[0], this.deleteCallable[0]) : persistentClass.getCustomSQLDeleteCheckStyle();
        Iterator iterator = persistentClass.getJoinClosureIterator();
        int n = 1;
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            this.qualifiedTableNames[n] = join.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            this.isInverseTable[n] = join.isInverse();
            this.isNullableTable[n] = join.isOptional();
            this.cascadeDeleteEnabled[n] = join.getKey().isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete();
            this.customSQLInsert[n] = join.getCustomSQLInsert();
            this.insertCallable[n] = this.customSQLInsert[n] != null && join.isCustomInsertCallable();
            this.insertResultCheckStyles[n] = join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n], this.insertCallable[n]) : join.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n] = join.getCustomSQLUpdate();
            this.updateCallable[n] = this.customSQLUpdate[n] != null && join.isCustomUpdateCallable();
            this.updateResultCheckStyles[n] = join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n], this.updateCallable[n]) : join.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n] = join.getCustomSQLDelete();
            this.deleteCallable[n] = this.customSQLDelete[n] != null && join.isCustomDeleteCallable();
            this.deleteResultCheckStyles[n] = join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n], this.deleteCallable[n]) : join.getCustomSQLDeleteCheckStyle();
            Iterator iterator2 = join.getKey().getColumnIterator();
            this.keyColumnNames[n] = new String[join.getKey().getColumnSpan()];
            int n2 = 0;
            while (iterator2.hasNext()) {
                cloneable2 = (Column)iterator2.next();
                this.keyColumnNames[n][n2++] = ((Column)cloneable2).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            ++n;
        }
        this.constraintOrderedTableNames = new String[this.qualifiedTableNames.length];
        this.constraintOrderedKeyColumnNames = new String[this.qualifiedTableNames.length][];
        int n3 = this.qualifiedTableNames.length - 1;
        int n4 = 0;
        while (n3 >= 0) {
            this.constraintOrderedTableNames[n4] = this.qualifiedTableNames[n3];
            this.constraintOrderedKeyColumnNames[n4] = this.keyColumnNames[n3];
            --n3;
            ++n4;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        n3 = this.isInstrumented() ? 1 : 0;
        n4 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        cloneable2 = new ArrayList<String[]>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList5 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList6 = new ArrayList<Boolean>();
        arrayList.add(this.qualifiedTableNames[0]);
        ((ArrayList)cloneable2).add(this.getIdentifierColumnNames());
        arrayList2.add(Boolean.TRUE);
        arrayList3.add(Boolean.FALSE);
        arrayList4.add(Boolean.FALSE);
        arrayList5.add(Boolean.FALSE);
        arrayList6.add(Boolean.FALSE);
        iterator = persistentClass.getSubclassJoinClosureIterator();
        while (iterator.hasNext()) {
            object4 = (Join)iterator.next();
            arrayList2.add(persistentClass.isClassOrSuperclassJoin((Join)object4));
            arrayList3.add(((Join)object4).isSequentialSelect());
            arrayList4.add(((Join)object4).isInverse());
            arrayList5.add(((Join)object4).isOptional());
            arrayList6.add(n3 != 0 && ((Join)object4).isLazy());
            if (((Join)object4).isSequentialSelect() && !persistentClass.isClassOrSuperclassJoin((Join)object4)) {
                n4 = 1;
            }
            arrayList.add(((Join)object4).getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()));
            object3 = ((Join)object4).getKey().getColumnIterator();
            serializable = new String[((Join)object4).getKey().getColumnSpan()];
            int n5 = 0;
            while (object3.hasNext()) {
                cloneable = (Column)object3.next();
                serializable[n5++] = ((Column)cloneable).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            ((ArrayList)cloneable2).add(serializable);
        }
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(arrayList3);
        this.subclassTableNameClosure = ArrayHelper.toStringArray(arrayList);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray(arrayList6);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(cloneable2);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(arrayList2);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(arrayList4);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(arrayList5);
        this.hasSequentialSelects = n4;
        if (persistentClass.isPolymorphic()) {
            object4 = persistentClass.getDiscriminator();
            if (object4 == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            object3 = (Selectable)object4.getColumnIterator().next();
            if (object4.hasFormula()) {
                serializable = (Formula)object3;
                this.discriminatorFormula = ((Formula)serializable).getFormula();
                this.discriminatorFormulaTemplate = ((Formula)serializable).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                this.discriminatorColumnName = null;
                this.discriminatorColumnReaders = null;
                this.discriminatorColumnReaderTemplate = null;
                this.discriminatorAlias = "clazz_";
            } else {
                serializable = (Column)object3;
                this.discriminatorColumnName = ((Column)serializable).getQuotedName(sessionFactoryImplementor.getDialect());
                this.discriminatorColumnReaders = ((Column)serializable).getReadExpr(sessionFactoryImplementor.getDialect());
                this.discriminatorColumnReaderTemplate = ((Column)serializable).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                this.discriminatorAlias = ((Column)serializable).getAlias(sessionFactoryImplementor.getDialect(), persistentClass.getRootTable());
                this.discriminatorFormula = null;
                this.discriminatorFormulaTemplate = null;
            }
            this.discriminatorType = persistentClass.getDiscriminator().getType();
            if (persistentClass.isDiscriminatorValueNull()) {
                this.discriminatorValue = NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = NULL_STRING;
                this.discriminatorInsertable = false;
            } else if (persistentClass.isDiscriminatorValueNotNull()) {
                this.discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = NOT_NULL_STRING;
                this.discriminatorInsertable = false;
            } else {
                this.discriminatorInsertable = persistentClass.isDiscriminatorInsertable() && !object4.hasFormula();
                try {
                    serializable = (DiscriminatorType)this.discriminatorType;
                    this.discriminatorValue = serializable.stringToObject(persistentClass.getDiscriminatorValue());
                    this.discriminatorSQLValue = serializable.objectToSQLString(this.discriminatorValue, sessionFactoryImplementor.getDialect());
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception exception) {
                    throw new MappingException("Could not format discriminator value to SQL string", exception);
                }
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorColumnReaders = null;
            this.discriminatorColumnReaderTemplate = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            this.discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormula = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        object4 = persistentClass.getPropertyClosureIterator();
        int n6 = 0;
        while (object4.hasNext()) {
            serializable = (Property)object4.next();
            this.propertyTableNumbers[n6++] = persistentClass.getJoinNumber((Property)serializable);
        }
        serializable = new ArrayList();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        cloneable = new ArrayList();
        object4 = persistentClass.getSubclassPropertyClosureIterator();
        while (object4.hasNext()) {
            Property property = (Property)object4.next();
            Integer n7 = persistentClass.getJoinNumber(property);
            ((ArrayList)cloneable).add(n7);
            this.propertyTableNumbersByNameAndSubclass.put(property.getPersistentClass().getEntityName() + '.' + property.getName(), n7);
            object2 = property.getColumnIterator();
            while (object2.hasNext()) {
                object = (Selectable)object2.next();
                if (object.isFormula()) {
                    arrayList7.add(n7);
                    continue;
                }
                ((ArrayList)serializable).add(n7);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray((Collection)((Object)serializable));
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(arrayList7);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray((Collection)((Object)cloneable));
        int n8 = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[n8];
        this.subclassClosure[0] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            this.subclassesByDiscriminatorValue.put(this.discriminatorValue, this.getEntityName());
        }
        if (persistentClass.isPolymorphic()) {
            object4 = persistentClass.getSubclassIterator();
            int n9 = 1;
            while (object4.hasNext()) {
                object2 = (Subclass)object4.next();
                this.subclassClosure[n9++] = ((PersistentClass)object2).getEntityName();
                if (((PersistentClass)object2).isDiscriminatorValueNull()) {
                    this.subclassesByDiscriminatorValue.put(NULL_DISCRIMINATOR, ((PersistentClass)object2).getEntityName());
                    continue;
                }
                if (((PersistentClass)object2).isDiscriminatorValueNotNull()) {
                    this.subclassesByDiscriminatorValue.put(NOT_NULL_DISCRIMINATOR, ((PersistentClass)object2).getEntityName());
                    continue;
                }
                try {
                    object = (DiscriminatorType)this.discriminatorType;
                    this.subclassesByDiscriminatorValue.put(object.stringToObject(((PersistentClass)object2).getDiscriminatorValue()), ((PersistentClass)object2).getEntityName());
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception exception) {
                    throw new MappingException("Error parsing discriminator value", exception);
                }
            }
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    public SingleTableEntityPersister(EntityBinding entityBinding, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(entityBinding, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        Serializable serializable;
        this.joinSpan = 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        TableSpecification tableSpecification = entityBinding.getPrimaryTable();
        this.qualifiedTableNames[0] = tableSpecification.getQualifiedName(sessionFactoryImplementor.getDialect());
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        SingleTableEntityPersister.initializeCustomSql(entityBinding.getCustomInsert(), 0, this.customSQLInsert, this.insertCallable, this.insertResultCheckStyles);
        SingleTableEntityPersister.initializeCustomSql(entityBinding.getCustomUpdate(), 0, this.customSQLUpdate, this.updateCallable, this.updateResultCheckStyles);
        SingleTableEntityPersister.initializeCustomSql(entityBinding.getCustomDelete(), 0, this.customSQLDelete, this.deleteCallable, this.deleteResultCheckStyles);
        this.constraintOrderedTableNames = new String[this.qualifiedTableNames.length];
        this.constraintOrderedKeyColumnNames = new String[this.qualifiedTableNames.length][];
        int n = this.qualifiedTableNames.length - 1;
        int n2 = 0;
        while (n >= 0) {
            this.constraintOrderedTableNames[n2] = this.qualifiedTableNames[n];
            this.constraintOrderedKeyColumnNames[n2] = this.keyColumnNames[n];
            --n;
            ++n2;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(entityBinding.getSynchronizedTableNames()));
        n = this.isInstrumented() ? 1 : 0;
        n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList5 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList6 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList7 = new ArrayList<Boolean>();
        arrayList.add(this.qualifiedTableNames[0]);
        arrayList2.add(this.getIdentifierColumnNames());
        arrayList3.add(Boolean.TRUE);
        arrayList4.add(Boolean.FALSE);
        arrayList5.add(Boolean.FALSE);
        arrayList6.add(Boolean.FALSE);
        arrayList7.add(Boolean.FALSE);
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(arrayList4);
        this.subclassTableNameClosure = ArrayHelper.toStringArray(arrayList);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray(arrayList7);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(arrayList2);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(arrayList3);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(arrayList5);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(arrayList6);
        this.hasSequentialSelects = n2;
        if (entityBinding.isPolymorphic()) {
            SimpleValue simpleValue = entityBinding.getHierarchyDetails().getEntityDiscriminator().getBoundValue();
            if (simpleValue == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = entityBinding.getHierarchyDetails().getEntityDiscriminator().isForced();
            if (DerivedValue.class.isInstance(simpleValue)) {
                serializable = (DerivedValue)simpleValue;
                this.discriminatorFormula = ((DerivedValue)((Object)serializable)).getExpression();
                this.discriminatorFormulaTemplate = SingleTableEntityPersister.getTemplateFromString(((DerivedValue)((Object)serializable)).getExpression(), sessionFactoryImplementor);
                this.discriminatorColumnName = null;
                this.discriminatorColumnReaders = null;
                this.discriminatorColumnReaderTemplate = null;
                this.discriminatorAlias = "clazz_";
            } else {
                serializable = (org.hibernate.metamodel.relational.Column)simpleValue;
                this.discriminatorColumnName = ((org.hibernate.metamodel.relational.Column)((Object)serializable)).getColumnName().encloseInQuotesIfQuoted(sessionFactoryImplementor.getDialect());
                this.discriminatorColumnReaders = ((org.hibernate.metamodel.relational.Column)((Object)serializable)).getReadFragment() == null ? ((org.hibernate.metamodel.relational.Column)((Object)serializable)).getColumnName().encloseInQuotesIfQuoted(sessionFactoryImplementor.getDialect()) : ((org.hibernate.metamodel.relational.Column)((Object)serializable)).getReadFragment();
                this.discriminatorColumnReaderTemplate = this.getTemplateFromColumn((org.hibernate.metamodel.relational.Column)((Object)serializable), sessionFactoryImplementor);
                this.discriminatorAlias = ((org.hibernate.metamodel.relational.Column)((Object)serializable)).getAlias(sessionFactoryImplementor.getDialect());
                this.discriminatorFormula = null;
                this.discriminatorFormulaTemplate = null;
            }
            this.discriminatorType = entityBinding.getHierarchyDetails().getEntityDiscriminator().getExplicitHibernateTypeDescriptor().getResolvedTypeMapping();
            if (entityBinding.getDiscriminatorMatchValue() == null) {
                this.discriminatorValue = NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = NULL_STRING;
                this.discriminatorInsertable = false;
            } else if (entityBinding.getDiscriminatorMatchValue().equals(NULL_STRING)) {
                this.discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = NOT_NULL_STRING;
                this.discriminatorInsertable = false;
            } else if (entityBinding.getDiscriminatorMatchValue().equals(NOT_NULL_STRING)) {
                this.discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = NOT_NULL_STRING;
                this.discriminatorInsertable = false;
            } else {
                this.discriminatorInsertable = entityBinding.getHierarchyDetails().getEntityDiscriminator().isInserted() && !DerivedValue.class.isInstance(simpleValue);
                try {
                    serializable = (DiscriminatorType)this.discriminatorType;
                    this.discriminatorValue = serializable.stringToObject(entityBinding.getDiscriminatorMatchValue());
                    this.discriminatorSQLValue = serializable.objectToSQLString(this.discriminatorValue, sessionFactoryImplementor.getDialect());
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception exception) {
                    throw new MappingException("Could not format discriminator value to SQL string", exception);
                }
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorColumnReaders = null;
            this.discriminatorColumnReaderTemplate = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            this.discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormula = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        int n3 = 0;
        for (AttributeBinding object2 : entityBinding.getAttributeBindingClosure()) {
            if (object2 == entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding() || !object2.getAttribute().isSingular()) continue;
            this.propertyTableNumbers[n3++] = 0;
        }
        serializable = new ArrayList();
        ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList9 = new ArrayList<Integer>();
        for (AttributeBinding n6 : entityBinding.getSubEntityAttributeBindingClosure()) {
            if (!n6.getAttribute().isSingular()) continue;
            SingularAttributeBinding singularAttributeBinding = (SingularAttributeBinding)n6;
            int entityBinding2 = 0;
            arrayList9.add(entityBinding2);
            this.propertyTableNumbersByNameAndSubclass.put(singularAttributeBinding.getContainer().getPathBase() + '.' + singularAttributeBinding.getAttribute().getName(), entityBinding2);
            for (SimpleValueBinding simpleValueBinding : singularAttributeBinding.getSimpleValueBindings()) {
                if (DerivedValue.class.isInstance(simpleValueBinding.getSimpleValue())) {
                    arrayList8.add(entityBinding2);
                    continue;
                }
                ((ArrayList)serializable).add(entityBinding2);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(serializable);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(arrayList8);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(arrayList9);
        int n4 = entityBinding.getSubEntityBindingClosureSpan() + 1;
        this.subclassClosure = new String[n4];
        this.subclassClosure[0] = this.getEntityName();
        if (entityBinding.isPolymorphic()) {
            this.subclassesByDiscriminatorValue.put(this.discriminatorValue, this.getEntityName());
        }
        if (entityBinding.isPolymorphic()) {
            int n5 = 1;
            for (EntityBinding entityBinding2 : entityBinding.getPostOrderSubEntityBindingClosure()) {
                this.subclassClosure[n5++] = entityBinding2.getEntity().getName();
                if (entityBinding2.isDiscriminatorMatchValueNull()) {
                    this.subclassesByDiscriminatorValue.put(NULL_DISCRIMINATOR, entityBinding2.getEntity().getName());
                    continue;
                }
                if (entityBinding2.isDiscriminatorMatchValueNotNull()) {
                    this.subclassesByDiscriminatorValue.put(NOT_NULL_DISCRIMINATOR, entityBinding2.getEntity().getName());
                    continue;
                }
                try {
                    DiscriminatorType classCastException = (DiscriminatorType)this.discriminatorType;
                    this.subclassesByDiscriminatorValue.put(classCastException.stringToObject(entityBinding2.getDiscriminatorMatchValue()), entityBinding2.getEntity().getName());
                }
                catch (ClassCastException exception) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception exception) {
                    throw new MappingException("Error parsing discriminator value", exception);
                }
            }
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(entityBinding);
        this.postConstruct(mapping);
    }

    private static void initializeCustomSql(CustomSQL customSQL, int n, String[] stringArray, boolean[] blArray, ExecuteUpdateResultCheckStyle[] executeUpdateResultCheckStyleArray) {
        stringArray[n] = customSQL != null ? customSQL.getSql() : null;
        blArray[n] = stringArray[n] != null && customSQL.isCallable();
        executeUpdateResultCheckStyleArray[n] = customSQL != null && customSQL.getCheckStyle() != null ? customSQL.getCheckStyle() : ExecuteUpdateResultCheckStyle.determineDefault(stringArray[n], blArray[n]);
    }

    protected boolean isInverseTable(int n) {
        return this.isInverseTable[n];
    }

    protected boolean isInverseSubclassTable(int n) {
        return this.isInverseSubclassTable[n];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public String getDiscriminatorColumnReaders() {
        return this.discriminatorColumnReaders;
    }

    public String getDiscriminatorColumnReaderTemplate() {
        return this.discriminatorColumnReaderTemplate;
    }

    protected String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    protected String getDiscriminatorFormulaTemplate() {
        return this.discriminatorFormulaTemplate;
    }

    public String getTableName() {
        return this.qualifiedTableNames[0];
    }

    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public String getSubclassForDiscriminatorValue(Object object) {
        if (object == null) {
            return (String)this.subclassesByDiscriminatorValue.get(NULL_DISCRIMINATOR);
        }
        String string = (String)this.subclassesByDiscriminatorValue.get(object);
        if (string == null) {
            string = (String)this.subclassesByDiscriminatorValue.get(NOT_NULL_DISCRIMINATOR);
        }
        return string;
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected boolean isDiscriminatorFormula() {
        return this.discriminatorColumnName == null;
    }

    protected String getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    protected String getTableName(int n) {
        return this.qualifiedTableNames[n];
    }

    protected String[] getKeyColumns(int n) {
        return this.keyColumnNames[n];
    }

    protected boolean isTableCascadeDeleteEnabled(int n) {
        return this.cascadeDeleteEnabled[n];
    }

    protected boolean isPropertyOfTable(int n, int n2) {
        return this.propertyTableNumbers[n] == n2;
    }

    protected boolean isSubclassTableSequentialSelect(int n) {
        return this.subclassTableSequentialSelect[n] && !this.isClassOrSuperclassTable[n];
    }

    public String fromTableFragment(String string) {
        return this.getTableName() + ' ' + string;
    }

    public String filterFragment(String string) throws MappingException {
        String string2 = this.discriminatorFilterFragment(string);
        if (this.hasWhere()) {
            string2 = string2 + " and " + this.getSQLWhereString(string);
        }
        return string2;
    }

    public String oneToManyFilterFragment(String string) throws MappingException {
        return this.forceDiscriminator ? this.discriminatorFilterFragment(string) : "";
    }

    private String discriminatorFilterFragment(String string) throws MappingException {
        if (this.needsDiscriminator()) {
            InFragment inFragment = new InFragment();
            if (this.isDiscriminatorFormula()) {
                inFragment.setFormula(string, this.getDiscriminatorFormulaTemplate());
            } else {
                inFragment.setColumn(string, this.getDiscriminatorColumnName());
            }
            String[] stringArray = this.getSubclassClosure();
            for (int i = 0; i < stringArray.length; ++i) {
                Queryable queryable = (Queryable)this.getFactory().getEntityPersister(stringArray[i]);
                if (queryable.isAbstract()) continue;
                inFragment.addValue(queryable.getDiscriminatorSQLValue());
            }
            StringBuilder stringBuilder = new StringBuilder(50).append(" and ").append(inFragment.toFragmentString());
            return stringBuilder.toString();
        }
        return "";
    }

    private boolean needsDiscriminator() {
        return this.forceDiscriminator || this.isInherited();
    }

    public String getSubclassPropertyTableName(int n) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[n]];
    }

    protected void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
        if (this.isDiscriminatorFormula()) {
            selectFragment.addFormula(string, this.getDiscriminatorFormulaTemplate(), this.getDiscriminatorAlias());
        } else {
            selectFragment.addColumn(string, this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
        }
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int n) {
        return this.subclassPropertyTableNumberClosure[n];
    }

    public int getTableSpan() {
        return this.joinSpan;
    }

    protected void addDiscriminatorToInsert(Insert insert) {
        if (this.discriminatorInsertable) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLValue);
        }
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.propertyTableNumbers;
    }

    protected boolean isSubclassPropertyDeferred(String string, String string2) {
        return this.hasSequentialSelects && this.isSubclassTableSequentialSelect(this.getSubclassPropertyTableNumber(string, string2));
    }

    public boolean hasSequentialSelect() {
        return this.hasSequentialSelects;
    }

    private int getSubclassPropertyTableNumber(String string, String string2) {
        Type type = this.propertyMapping.toType(string);
        if (type.isAssociationType() && ((AssociationType)type).useLHSPrimaryKey()) {
            return 0;
        }
        Integer n = (Integer)this.propertyTableNumbersByNameAndSubclass.get(string2 + '.' + string);
        return n == null ? 0 : n;
    }

    protected String getSequentialSelect(String string) {
        return (String)this.sequentialSelectStringsByEntityName.get(string);
    }

    private String generateSequentialSelect(Loadable loadable) {
        AbstractEntityPersister abstractEntityPersister = (AbstractEntityPersister)loadable;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        String[] stringArray = abstractEntityPersister.getPropertyNames();
        String[] stringArray2 = abstractEntityPersister.getPropertySubclassNames();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.getSubclassPropertyTableNumber(stringArray[i], stringArray2[i]);
            if (!this.isSubclassTableSequentialSelect(n) || this.isSubclassTableLazy(n)) continue;
            hashSet.add(n);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.getSubclassColumnTableNumberClosure();
        for (int i = 0; i < this.getSubclassColumnClosure().length; ++i) {
            if (!hashSet.contains(nArray[i])) continue;
            arrayList.add(i);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int[] nArray2 = this.getSubclassColumnTableNumberClosure();
        for (int i = 0; i < this.getSubclassFormulaTemplateClosure().length; ++i) {
            if (!hashSet.contains(nArray2[i])) continue;
            arrayList2.add(i);
        }
        return this.renderSelect(ArrayHelper.toIntArray(hashSet), ArrayHelper.toIntArray(arrayList), ArrayHelper.toIntArray(arrayList2));
    }

    protected String[] getSubclassTableKeyColumns(int n) {
        return this.subclassTableKeyColumnClosure[n];
    }

    public String getSubclassTableName(int n) {
        return this.subclassTableNameClosure[n];
    }

    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isClassOrSuperclassTable(int n) {
        return this.isClassOrSuperclassTable[n];
    }

    protected boolean isSubclassTableLazy(int n) {
        return this.subclassTableIsLazyClosure[n];
    }

    protected boolean isNullableTable(int n) {
        return this.isNullableTable[n];
    }

    protected boolean isNullableSubclassTable(int n) {
        return this.isNullableSubclassTable[n];
    }

    public String getPropertyTableName(String string) {
        Integer n = this.getEntityMetamodel().getPropertyIndexOrNull(string);
        if (n == null) {
            return null;
        }
        return this.qualifiedTableNames[this.propertyTableNumbers[n]];
    }

    public void postInstantiate() {
        super.postInstantiate();
        if (this.hasSequentialSelects) {
            String[] stringArray = this.getSubclassClosure();
            for (int i = 1; i < stringArray.length; ++i) {
                Loadable loadable = (Loadable)this.getFactory().getEntityPersister(stringArray[i]);
                if (loadable.isAbstract()) continue;
                String string = this.generateSequentialSelect(loadable);
                this.sequentialSelectStringsByEntityName.put(stringArray[i], string);
            }
        }
    }

    public boolean isMultiTable() {
        return this.getTableSpan() > 1;
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public FilterAliasGenerator getFilterAliasGenerator(String string) {
        return new DynamicFilterAliasGenerator(this.qualifiedTableNames, string);
    }
}

