/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NamedQueryLoader.class.getName());

    public NamedQueryLoader(String string, EntityPersister entityPersister) {
        this.queryName = string;
        this.persister = entityPersister;
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
        if (lockOptions != null) {
            LOG.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(serializable, object, sessionImplementor);
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        LOG.debugf("Loading entity: %s using named query: %s", (Object)this.persister.getEntityName(), (Object)this.queryName);
        AbstractQueryImpl abstractQueryImpl = (AbstractQueryImpl)sessionImplementor.getNamedQuery(this.queryName);
        if (abstractQueryImpl.hasNamedParameters()) {
            abstractQueryImpl.setParameter(abstractQueryImpl.getNamedParameters()[0], (Object)serializable, this.persister.getIdentifierType());
        } else {
            abstractQueryImpl.setParameter(0, (Object)serializable, this.persister.getIdentifierType());
        }
        abstractQueryImpl.setOptionalId(serializable);
        abstractQueryImpl.setOptionalEntityName(this.persister.getEntityName());
        abstractQueryImpl.setOptionalObject(object);
        abstractQueryImpl.setFlushMode(FlushMode.MANUAL);
        abstractQueryImpl.list();
        return sessionImplementor.getPersistenceContext().getEntity(sessionImplementor.generateEntityKey(serializable, this.persister));
    }
}

