/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class JoinedSubclassEntityPersister
extends AbstractEntityPersister {
    private final int tableSpan;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] tableKeyColumnReaders;
    private final String[][] tableKeyColumnReaderTemplates;
    private final String[][] naturalOrderTableKeyColumns;
    private final String[][] naturalOrderTableKeyColumnReaders;
    private final String[][] naturalOrderTableKeyColumnReaderTemplates;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final boolean[] subclassTableSequentialSelect;
    private final boolean[] subclassTableIsLazyClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final String[] discriminatorValues;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final Object discriminatorValue;
    private final String discriminatorSQLString;
    private final int coreTableSpan;
    private final boolean[] isNullableTable;

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(persistentClass, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        Integer n;
        Object object;
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        int n2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        ArrayList<Object> arrayList;
        Object object8;
        if (persistentClass.isPolymorphic()) {
            try {
                this.discriminatorValue = persistentClass.getSubclassId();
                this.discriminatorSQLString = this.discriminatorValue.toString();
            }
            catch (Exception exception) {
                throw new MappingException("Could not format discriminator value to SQL string", exception);
            }
        } else {
            this.discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockStyle() == OptimisticLockStyle.ALL || this.optimisticLockStyle() == OptimisticLockStyle.DIRTY) {
            throw new MappingException("optimistic-lock=all|dirty not supported for joined-subclass mappings [" + this.getEntityName() + "]");
        }
        int n3 = this.getIdentifierColumnSpan();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<String[]> arrayList4 = new ArrayList<String[]>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<Boolean> arrayList6 = new ArrayList<Boolean>();
        Iterator iterator = persistentClass.getTableClosureIterator();
        Iterator iterator2 = persistentClass.getKeyClosureIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            object8 = (KeyValue)iterator2.next();
            arrayList = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList2.add(arrayList);
            object7 = new String[n3];
            object6 = new String[n3];
            object5 = new String[n3];
            Iterator iterator3 = object8.getColumnIterator();
            for (int i = 0; i < n3; ++i) {
                object4 = (String[])iterator3.next();
                object7[i] = object4.getQuotedName(sessionFactoryImplementor.getDialect());
                object6[i] = object4.getReadExpr(sessionFactoryImplementor.getDialect());
                object5[i] = object4.getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
            }
            arrayList3.add(object7);
            arrayList4.add((String[])object6);
            arrayList5.add(object5);
            arrayList6.add(object8.isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete());
        }
        this.coreTableSpan = arrayList2.size();
        this.isNullableTable = new boolean[persistentClass.getJoinClosureSpan()];
        int n4 = 0;
        object8 = persistentClass.getJoinClosureIterator();
        while (object8.hasNext()) {
            arrayList = (Join)object8.next();
            this.isNullableTable[n4++] = ((Join)((Object)arrayList)).isOptional();
            object7 = ((Join)((Object)arrayList)).getTable();
            object6 = ((Table)object7).getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList2.add(object6);
            object5 = ((Join)((Object)arrayList)).getKey();
            int n5 = object5.getColumnSpan();
            String[] stringArray = new String[n5];
            object4 = new String[n5];
            object3 = new String[n5];
            Iterator iterator4 = object5.getColumnIterator();
            for (n2 = 0; n2 < n5; ++n2) {
                serializable2 = (Column)iterator4.next();
                stringArray[n2] = ((Column)serializable2).getQuotedName(sessionFactoryImplementor.getDialect());
                object4[n2] = ((Column)serializable2).getReadExpr(sessionFactoryImplementor.getDialect());
                object3[n2] = ((Column)serializable2).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
            }
            arrayList3.add(stringArray);
            arrayList4.add((String[])object4);
            arrayList5.add(object3);
            arrayList6.add(object5.isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete());
        }
        this.naturalOrderTableNames = ArrayHelper.toStringArray(arrayList2);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(arrayList3);
        this.naturalOrderTableKeyColumnReaders = ArrayHelper.to2DStringArray(arrayList4);
        this.naturalOrderTableKeyColumnReaderTemplates = ArrayHelper.to2DStringArray(arrayList5);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(arrayList6);
        arrayList = new ArrayList<Object>();
        object7 = new ArrayList();
        object6 = new ArrayList();
        object5 = new ArrayList();
        arrayList3 = new ArrayList();
        iterator = persistentClass.getSubclassTableClosureIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            ((ArrayList)object7).add(persistentClass.isClassOrSuperclassTable(table));
            ((ArrayList)object6).add(Boolean.FALSE);
            ((ArrayList)object5).add(Boolean.FALSE);
            String string = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList.add(string);
            object4 = new String[n3];
            object3 = table.getPrimaryKey().getColumnIterator();
            for (int i = 0; i < n3; ++i) {
                object4[i] = ((Column)object3.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList3.add(object4);
        }
        object8 = persistentClass.getSubclassJoinClosureIterator();
        while (object8.hasNext()) {
            Join join = (Join)object8.next();
            Table table = join.getTable();
            ((ArrayList)object7).add(persistentClass.isClassOrSuperclassTable(table));
            ((ArrayList)object6).add(join.isSequentialSelect());
            ((ArrayList)object5).add(join.isLazy());
            object4 = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList.add(object4);
            object3 = new String[n3];
            Iterator iterator5 = table.getPrimaryKey().getColumnIterator();
            for (n2 = 0; n2 < n3; ++n2) {
                object3[n2] = ((Column)iterator5.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList3.add(object3);
        }
        String[] stringArray = ArrayHelper.toStringArray(arrayList);
        String[][] stringArray2 = ArrayHelper.to2DStringArray(arrayList3);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray((Collection)object7);
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray((Collection)object6);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray((Collection)object5);
        this.constraintOrderedTableNames = new String[stringArray.length];
        this.constraintOrderedKeyColumnNames = new String[stringArray.length][];
        int n6 = 0;
        int n7 = stringArray.length - 1;
        while (n7 >= 0) {
            this.constraintOrderedTableNames[n6] = stringArray[n7];
            this.constraintOrderedKeyColumnNames[n6] = stringArray2[n7];
            --n7;
            ++n6;
        }
        this.tableSpan = this.naturalOrderTableNames.length;
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames, this.coreTableSpan);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns, this.coreTableSpan);
        this.tableKeyColumnReaders = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaders, this.coreTableSpan);
        this.tableKeyColumnReaderTemplates = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaderTemplates, this.coreTableSpan);
        this.subclassTableNameClosure = JoinedSubclassEntityPersister.reverse(stringArray, this.coreTableSpan);
        this.subclassTableKeyColumnClosure = JoinedSubclassEntityPersister.reverse(stringArray2, this.coreTableSpan);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        int n8 = this.coreTableSpan - 1;
        for (PersistentClass persistentClass2 = persistentClass; persistentClass2 != null; persistentClass2 = persistentClass2.getSuperclass()) {
            this.customSQLInsert[n8] = persistentClass2.getCustomSQLInsert();
            this.insertCallable[n8] = this.customSQLInsert[n8] != null && persistentClass2.isCustomInsertCallable();
            this.insertResultCheckStyles[n8] = persistentClass2.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n8], this.insertCallable[n8]) : persistentClass2.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n8] = persistentClass2.getCustomSQLUpdate();
            this.updateCallable[n8] = this.customSQLUpdate[n8] != null && persistentClass2.isCustomUpdateCallable();
            this.updateResultCheckStyles[n8] = persistentClass2.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n8], this.updateCallable[n8]) : persistentClass2.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n8] = persistentClass2.getCustomSQLDelete();
            this.deleteCallable[n8] = this.customSQLDelete[n8] != null && persistentClass2.isCustomDeleteCallable();
            this.deleteResultCheckStyles[n8] = persistentClass2.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n8], this.deleteCallable[n8]) : persistentClass2.getCustomSQLDeleteCheckStyle();
            --n8;
        }
        if (n8 != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hiearchy.");
        }
        object8 = persistentClass.getJoinClosureIterator();
        n2 = this.coreTableSpan;
        while (object8.hasNext()) {
            serializable2 = (Join)object8.next();
            this.customSQLInsert[n2] = ((Join)serializable2).getCustomSQLInsert();
            this.insertCallable[n2] = this.customSQLInsert[n2] != null && ((Join)serializable2).isCustomInsertCallable();
            this.insertResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n2], this.insertCallable[n2]) : ((Join)serializable2).getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n2] = ((Join)serializable2).getCustomSQLUpdate();
            this.updateCallable[n2] = this.customSQLUpdate[n2] != null && ((Join)serializable2).isCustomUpdateCallable();
            this.updateResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n2], this.updateCallable[n2]) : ((Join)serializable2).getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n2] = ((Join)serializable2).getCustomSQLDelete();
            this.deleteCallable[n2] = this.customSQLDelete[n2] != null && ((Join)serializable2).isCustomDeleteCallable();
            this.deleteResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n2], this.deleteCallable[n2]) : ((Join)serializable2).getCustomSQLDeleteCheckStyle();
            ++n2;
        }
        int n9 = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[n9];
        this.propertyTableNumbers = new int[n9];
        Iterator iterator6 = persistentClass.getPropertyClosureIterator();
        int n10 = 0;
        while (iterator6.hasNext()) {
            serializable = (Property)iterator6.next();
            object2 = ((Property)serializable).getValue().getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            this.propertyTableNumbers[n10] = JoinedSubclassEntityPersister.getTableId((String)object2, this.tableNames);
            this.naturalOrderPropertyTableNumbers[n10] = JoinedSubclassEntityPersister.getTableId((String)object2, this.naturalOrderTableNames);
            ++n10;
        }
        serializable = new ArrayList();
        object2 = new ArrayList();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        iterator6 = persistentClass.getSubclassPropertyClosureIterator();
        while (iterator6.hasNext()) {
            Property property = (Property)iterator6.next();
            Table table = property.getValue().getTable();
            object = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            n = JoinedSubclassEntityPersister.getTableId((String)object, this.subclassTableNameClosure);
            arrayList7.add(n);
            Iterator iterator7 = property.getColumnIterator();
            while (iterator7.hasNext()) {
                Selectable selectable = (Selectable)iterator7.next();
                if (selectable.isFormula()) {
                    ((ArrayList)object2).add(n);
                    continue;
                }
                ((ArrayList)serializable).add(n);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray((Collection)((Object)serializable));
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(arrayList7);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray((Collection)object2);
        int n11 = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[n11];
        this.subclassClosure[n11 - 1] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            int n12;
            this.subclassesByDiscriminatorValue.put(this.discriminatorValue, this.getEntityName());
            this.discriminatorValues = new String[n11];
            this.discriminatorValues[n11 - 1] = this.discriminatorSQLString;
            this.notNullColumnTableNumbers = new int[n11];
            this.notNullColumnTableNumbers[n11 - 1] = n12 = JoinedSubclassEntityPersister.getTableId(persistentClass.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
            this.notNullColumnNames = new String[n11];
            this.notNullColumnNames[n11 - 1] = this.subclassTableKeyColumnClosure[n12][0];
        } else {
            this.discriminatorValues = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        }
        iterator6 = persistentClass.getSubclassIterator();
        int n13 = 0;
        while (iterator6.hasNext()) {
            object = (Subclass)iterator6.next();
            this.subclassClosure[n13] = ((PersistentClass)object).getEntityName();
            try {
                if (persistentClass.isPolymorphic()) {
                    int n14;
                    n = ((Subclass)object).getSubclassId();
                    this.subclassesByDiscriminatorValue.put(n, ((PersistentClass)object).getEntityName());
                    this.discriminatorValues[n13] = n.toString();
                    this.notNullColumnTableNumbers[n13] = n14 = JoinedSubclassEntityPersister.getTableId(((Subclass)object).getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                    this.notNullColumnNames[n13] = this.subclassTableKeyColumnClosure[n14][0];
                }
            }
            catch (Exception exception) {
                throw new MappingException("Error parsing discriminator value", exception);
            }
            ++n13;
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    public JoinedSubclassEntityPersister(EntityBinding entityBinding, EntityRegionAccessStrategy entityRegionAccessStrategy, NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(entityBinding, entityRegionAccessStrategy, naturalIdRegionAccessStrategy, sessionFactoryImplementor);
        this.tableSpan = -1;
        this.tableNames = null;
        this.naturalOrderTableNames = null;
        this.tableKeyColumns = null;
        this.tableKeyColumnReaders = null;
        this.tableKeyColumnReaderTemplates = null;
        this.naturalOrderTableKeyColumns = null;
        this.naturalOrderTableKeyColumnReaders = null;
        this.naturalOrderTableKeyColumnReaderTemplates = null;
        this.naturalOrderCascadeDeleteEnabled = null;
        this.spaces = null;
        this.subclassClosure = null;
        this.subclassTableNameClosure = null;
        this.subclassTableKeyColumnClosure = null;
        this.isClassOrSuperclassTable = null;
        this.naturalOrderPropertyTableNumbers = null;
        this.propertyTableNumbers = null;
        this.subclassPropertyTableNumberClosure = null;
        this.subclassColumnTableNumberClosure = null;
        this.subclassFormulaTableNumberClosure = null;
        this.subclassTableSequentialSelect = null;
        this.subclassTableIsLazyClosure = null;
        this.discriminatorValues = null;
        this.notNullColumnNames = null;
        this.notNullColumnTableNumbers = null;
        this.constraintOrderedTableNames = null;
        this.constraintOrderedKeyColumnNames = null;
        this.discriminatorValue = null;
        this.discriminatorSQLString = null;
        this.coreTableSpan = -1;
        this.isNullableTable = null;
    }

    protected boolean isNullableTable(int n) {
        if (n < this.coreTableSpan) {
            return false;
        }
        return this.isNullableTable[n - this.coreTableSpan];
    }

    protected boolean isSubclassTableSequentialSelect(int n) {
        return this.subclassTableSequentialSelect[n] && !this.isClassOrSuperclassTable[n];
    }

    public String getSubclassPropertyTableName(int n) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[n]];
    }

    public Type getDiscriminatorType() {
        return StandardBasicTypes.INTEGER;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    public String getSubclassForDiscriminatorValue(Object object) {
        return (String)this.subclassesByDiscriminatorValue.get(object);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected String getTableName(int n) {
        return this.naturalOrderTableNames[n];
    }

    protected String[] getKeyColumns(int n) {
        return this.naturalOrderTableKeyColumns[n];
    }

    protected boolean isTableCascadeDeleteEnabled(int n) {
        return this.naturalOrderCascadeDeleteEnabled[n];
    }

    protected boolean isPropertyOfTable(int n, int n2) {
        return this.naturalOrderPropertyTableNumbers[n] == n2;
    }

    private static final void reverse(Object[] objectArray, int n) {
        int n2;
        Object[] objectArray2 = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n - n2 - 1];
        }
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = objectArray2[n2];
        }
    }

    private static String[] reverse(String[] stringArray, int n) {
        int n2;
        int n3 = stringArray.length;
        String[] stringArray2 = new String[n3];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray2[n2] = stringArray[n - n2 - 1];
        }
        for (n2 = n; n2 < n3; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        return stringArray2;
    }

    private static String[][] reverse(String[][] stringArray, int n) {
        int n2;
        int n3 = stringArray.length;
        String[][] stringArray2 = new String[n3][];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray2[n2] = stringArray[n - n2 - 1];
        }
        for (n2 = n; n2 < n3; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        return stringArray2;
    }

    public String fromTableFragment(String string) {
        return this.getTableName() + ' ' + string;
    }

    public String getTableName() {
        return this.tableNames[0];
    }

    public void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
        if (this.hasSubclasses()) {
            selectFragment.setExtraSelectList(this.discriminatorFragment(string), this.getDiscriminatorAlias());
        }
    }

    private CaseFragment discriminatorFragment(String string) {
        CaseFragment caseFragment = this.getFactory().getDialect().createCaseFragment();
        for (int i = 0; i < this.discriminatorValues.length; ++i) {
            caseFragment.addWhenColumnNotNull(JoinedSubclassEntityPersister.generateTableAlias(string, this.notNullColumnTableNumbers[i]), this.notNullColumnNames[i], this.discriminatorValues[i]);
        }
        return caseFragment;
    }

    public String filterFragment(String string) {
        return this.hasWhere() ? " and " + this.getSQLWhereString(this.generateFilterConditionAlias(string)) : "";
    }

    public String generateFilterConditionAlias(String string) {
        return JoinedSubclassEntityPersister.generateTableAlias(string, this.tableSpan - 1);
    }

    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    public String[] getIdentifierColumnReaderTemplates() {
        return this.tableKeyColumnReaderTemplates[0];
    }

    public String[] getIdentifierColumnReaders() {
        return this.tableKeyColumnReaders[0];
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        if ("class".equals(string2)) {
            return new String[]{this.discriminatorFragment(string).toFragmentString()};
        }
        return super.toColumns(string, string2);
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int n) {
        return this.subclassPropertyTableNumberClosure[n];
    }

    public int getTableSpan() {
        return this.tableSpan;
    }

    public boolean isMultiTable() {
        return true;
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    protected String[] getSubclassTableKeyColumns(int n) {
        return this.subclassTableKeyColumnClosure[n];
    }

    public String getSubclassTableName(int n) {
        return this.subclassTableNameClosure[n];
    }

    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isSubclassTableLazy(int n) {
        return this.subclassTableIsLazyClosure[n];
    }

    protected boolean isClassOrSuperclassTable(int n) {
        return this.isClassOrSuperclassTable[n];
    }

    public String getPropertyTableName(String string) {
        Integer n = this.getEntityMetamodel().getPropertyIndexOrNull(string);
        if (n == null) {
            return null;
        }
        return this.tableNames[this.propertyTableNumbers[n]];
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public String getRootTableName() {
        return this.naturalOrderTableNames[0];
    }

    public String getRootTableAlias(String string) {
        return JoinedSubclassEntityPersister.generateTableAlias(string, JoinedSubclassEntityPersister.getTableId(this.getRootTableName(), this.tableNames));
    }

    public Queryable.Declarer getSubclassPropertyDeclarer(String string) {
        if ("class".equals(string)) {
            return Queryable.Declarer.SUBCLASS;
        }
        return super.getSubclassPropertyDeclarer(string);
    }

    public int determineTableNumberForColumn(String string) {
        String[] stringArray = this.getSubclassColumnClosure();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = stringArray[i].startsWith("\"") && stringArray[i].endsWith("\"");
            if (!(bl ? stringArray[i].equals(string) : stringArray[i].equalsIgnoreCase(string))) continue;
            return this.getSubclassColumnTableNumberClosure()[i];
        }
        throw new HibernateException("Could not locate table which owns column [" + string + "] referenced in order-by mapping");
    }

    public FilterAliasGenerator getFilterAliasGenerator(String string) {
        return new DynamicFilterAliasGenerator(this.subclassTableNameClosure, string);
    }
}

