/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectOneToManyLoader;
import org.hibernate.loader.entity.CollectionElementLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;

public class OneToManyPersister
extends AbstractCollectionPersister {
    private final boolean cascadeDeleteEnabled;
    private final boolean keyIsNullable;
    private final boolean keyIsUpdateable;
    private BasicBatchKey deleteRowBatchKey;
    private BasicBatchKey insertRowBatchKey;

    protected boolean isRowDeleteEnabled() {
        return this.keyIsUpdateable && this.keyIsNullable;
    }

    protected boolean isRowInsertEnabled() {
        return this.keyIsUpdateable;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public OneToManyPersister(Collection collection, CollectionRegionAccessStrategy collectionRegionAccessStrategy, Configuration configuration, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException, CacheException {
        super(collection, collectionRegionAccessStrategy, configuration, sessionFactoryImplementor);
        this.cascadeDeleteEnabled = collection.getKey().isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete();
        this.keyIsNullable = collection.getKey().isNullable();
        this.keyIsUpdateable = collection.getKey().isUpdateable();
    }

    protected String generateDeleteString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").addPrimaryKeyColumns(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.hasWhere) {
            update.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateInsertRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("create one-to-many row " + this.getRole());
        }
        return update.addPrimaryKeyColumns(this.elementColumnNames, this.elementColumnWriters).toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName);
        update.addPrimaryKeyColumns(this.elementColumnNames, this.elementColumnIsSettable, this.elementColumnWriters);
        if (this.hasIdentifier) {
            update.addPrimaryKeyColumns(new String[]{this.identifierColumnName});
        }
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames);
        }
        return update.toStatementString();
    }

    protected String generateDeleteRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many row " + this.getRole());
        }
        String[] stringArray = ArrayHelper.join(this.keyColumnNames, this.elementColumnNames);
        return update.addPrimaryKeyColumns(stringArray).toStatementString();
    }

    public void recreate(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        super.recreate(persistentCollection, serializable, sessionImplementor);
        this.writeIndex(persistentCollection, persistentCollection.entries(this), serializable, sessionImplementor);
    }

    public void insertRows(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        super.insertRows(persistentCollection, serializable, sessionImplementor);
        this.writeIndex(persistentCollection, persistentCollection.entries(this), serializable, sessionImplementor);
    }

    protected void doProcessQueuedOps(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        this.writeIndex(persistentCollection, persistentCollection.queuedAdditionIterator(), serializable, sessionImplementor);
    }

    private void writeIndex(PersistentCollection persistentCollection, Iterator iterator, Serializable serializable, SessionImplementor sessionImplementor) {
        block18: {
            if (this.isInverse && this.hasIndex && !this.indexContainsFormula) {
                try {
                    if (!iterator.hasNext()) break block18;
                    Expectation expectation = Expectations.appropriateExpectation(this.getUpdateCheckStyle());
                    int n = 0;
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (persistentCollection.entryExists(e, n)) {
                            int n3 = 1;
                            PreparedStatement preparedStatement = null;
                            boolean bl = this.isUpdateCallable();
                            boolean bl2 = expectation.canBeBatched();
                            String string = this.getSQLUpdateRowString();
                            if (bl2) {
                                if (this.recreateBatchKey == null) {
                                    this.recreateBatchKey = new BasicBatchKey(this.getRole() + "#RECREATE", expectation);
                                }
                                preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.recreateBatchKey).getBatchStatement(string, bl);
                            } else {
                                preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, bl);
                            }
                            try {
                                n3 += expectation.prepare(preparedStatement);
                                if (this.hasIdentifier) {
                                    n3 = this.writeIdentifier(preparedStatement, persistentCollection.getIdentifier(e, n), n3, sessionImplementor);
                                }
                                n3 = this.writeIndex(preparedStatement, persistentCollection.getIndex(e, n, this), n3, sessionImplementor);
                                n3 = this.writeElement(preparedStatement, persistentCollection.getElement(e), n3, sessionImplementor);
                                if (bl2) {
                                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.recreateBatchKey).addToBatch();
                                } else {
                                    expectation.verifyOutcome(sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement), preparedStatement, -1);
                                }
                                ++n2;
                            }
                            catch (SQLException sQLException) {
                                if (bl2) {
                                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().abortBatch();
                                }
                                throw sQLException;
                            }
                            finally {
                                if (!bl2) {
                                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                                }
                            }
                        }
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    throw this.sqlExceptionHelper.convert(sQLException, "could not update collection: " + MessageHelper.collectionInfoString(this, persistentCollection, serializable, sessionImplementor), this.getSQLUpdateRowString());
                }
            }
        }
    }

    public boolean consumesEntityAlias() {
        return true;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return true;
    }

    public boolean isManyToMany() {
        return false;
    }

    protected int doUpdateRows(Serializable serializable, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) {
        try {
            int n;
            Object e;
            Object object;
            boolean bl;
            Expectation expectation;
            int n2 = 0;
            if (this.isRowDeleteEnabled()) {
                expectation = Expectations.appropriateExpectation(this.getDeleteCheckStyle());
                bl = expectation.canBeBatched();
                if (bl && this.deleteRowBatchKey == null) {
                    this.deleteRowBatchKey = new BasicBatchKey(this.getRole() + "#DELETEROW", expectation);
                }
                String string = this.getSQLDeleteRowString();
                object = null;
                try {
                    int n3 = 0;
                    Iterator iterator = persistentCollection.entries(this);
                    int n4 = 1;
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (persistentCollection.needsUpdating(e, n3, this.elementType)) {
                            object = bl ? sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.deleteRowBatchKey).getBatchStatement(string, this.isDeleteCallable()) : sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, this.isDeleteCallable());
                            n = this.writeKey((PreparedStatement)object, serializable, n4, sessionImplementor);
                            this.writeElementToWhere((PreparedStatement)object, persistentCollection.getSnapshotElement(e, n3), n, sessionImplementor);
                            if (bl) {
                                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.deleteRowBatchKey).addToBatch();
                            } else {
                                expectation.verifyOutcome(sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate((PreparedStatement)object), (PreparedStatement)object, -1);
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().abortBatch();
                    }
                    throw sQLException;
                }
                finally {
                    if (!bl) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release((Statement)object);
                    }
                }
            }
            if (this.isRowInsertEnabled()) {
                expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                bl = expectation.canBeBatched();
                boolean bl2 = this.isInsertCallable();
                if (bl && this.insertRowBatchKey == null) {
                    this.insertRowBatchKey = new BasicBatchKey(this.getRole() + "#INSERTROW", expectation);
                }
                object = this.getSQLInsertRowString();
                PreparedStatement preparedStatement = null;
                try {
                    int n5 = 0;
                    Iterator iterator = persistentCollection.entries(this);
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        n = 1;
                        if (persistentCollection.needsUpdating(e, n5, this.elementType)) {
                            preparedStatement = bl ? sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.insertRowBatchKey).getBatchStatement((String)object, bl2) : sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)object, bl2);
                            int n6 = this.writeKey(preparedStatement, serializable, n += expectation.prepare(preparedStatement), sessionImplementor);
                            if (this.hasIndex && !this.indexContainsFormula) {
                                n6 = this.writeIndexToWhere(preparedStatement, persistentCollection.getIndex(e, n5, this), n6, sessionImplementor);
                            }
                            this.writeElementToWhere(preparedStatement, persistentCollection.getElement(e), n6, sessionImplementor);
                            if (bl) {
                                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.insertRowBatchKey).addToBatch();
                            } else {
                                expectation.verifyOutcome(sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement), preparedStatement, -1);
                            }
                            ++n2;
                        }
                        ++n5;
                    }
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().abortBatch();
                    }
                    throw sQLException;
                }
                finally {
                    if (!bl) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                }
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw this.getFactory().getSQLExceptionHelper().convert(sQLException, "could not update collection rows: " + MessageHelper.collectionInfoString(this, persistentCollection, serializable, sessionImplementor), this.getSQLInsertRowString());
        }
    }

    public String selectFragment(Joinable joinable, String string, String string2, String string3, String string4, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(this.selectFragment(string2, string4)).append(", ");
        }
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)this.getElementPersister();
        return stringBuilder.append(outerJoinLoadable.selectFragment(string2, string3)).toString();
    }

    protected CollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return BatchingCollectionInitializerBuilder.getBuilder(this.getFactory()).createBatchingOneToManyInitializer(this, this.batchSize, this.getFactory(), loadQueryInfluencers);
    }

    public String fromJoinFragment(String string, boolean bl, boolean bl2) {
        return ((Joinable)((Object)this.getElementPersister())).fromJoinFragment(string, bl, bl2);
    }

    public String whereJoinFragment(String string, boolean bl, boolean bl2) {
        return ((Joinable)((Object)this.getElementPersister())).whereJoinFragment(string, bl, bl2);
    }

    public String getTableName() {
        return ((Joinable)((Object)this.getElementPersister())).getTableName();
    }

    public String filterFragment(String string) throws MappingException {
        String string2 = super.filterFragment(string);
        if (this.getElementPersister() instanceof Joinable) {
            string2 = string2 + ((Joinable)((Object)this.getElementPersister())).oneToManyFilterFragment(string);
        }
        return string2;
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselectFetch, SessionImplementor sessionImplementor) {
        return new SubselectOneToManyLoader(this, subselectFetch.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselectFetch.getResult(), subselectFetch.getQueryParameters(), subselectFetch.getNamedParameterLocMap(), sessionImplementor.getFactory(), sessionImplementor.getLoadQueryInfluencers());
    }

    public Object getElementByIndex(Serializable serializable, Object object, SessionImplementor sessionImplementor, Object object2) {
        return new CollectionElementLoader(this, this.getFactory(), sessionImplementor.getLoadQueryInfluencers()).loadElement(sessionImplementor, serializable, this.incrementIndexByBase(object));
    }

    public FilterAliasGenerator getFilterAliasGenerator(String string) {
        return this.getElementPersister().getFilterAliasGenerator(string);
    }
}

