/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;
import org.jboss.logging.Logger;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NamedQueryCollectionInitializer.class.getName());
    private final String queryName;
    private final CollectionPersister persister;

    public NamedQueryCollectionInitializer(String string, CollectionPersister collectionPersister) {
        this.queryName = string;
        this.persister = collectionPersister;
    }

    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        LOG.debugf("Initializing collection: %s using named query: %s", (Object)this.persister.getRole(), (Object)this.queryName);
        AbstractQueryImpl abstractQueryImpl = (AbstractQueryImpl)sessionImplementor.getNamedSQLQuery(this.queryName);
        if (abstractQueryImpl.getNamedParameters().length > 0) {
            abstractQueryImpl.setParameter(abstractQueryImpl.getNamedParameters()[0], (Object)serializable, this.persister.getKeyType());
        } else {
            abstractQueryImpl.setParameter(0, (Object)serializable, this.persister.getKeyType());
        }
        abstractQueryImpl.setCollectionKey(serializable).setFlushMode(FlushMode.MANUAL).list();
    }
}

