/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import org.hibernate.QueryException;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CollectionPropertyMapping
implements PropertyMapping {
    private final QueryableCollection memberPersister;

    public CollectionPropertyMapping(QueryableCollection queryableCollection) {
        this.memberPersister = queryableCollection;
    }

    public Type toType(String string) throws QueryException {
        if (string.equals("elements")) {
            return this.memberPersister.getElementType();
        }
        if (string.equals("indices")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before indices()");
            }
            return this.memberPersister.getIndexType();
        }
        if (string.equals("size")) {
            return StandardBasicTypes.INTEGER;
        }
        if (string.equals("maxIndex")) {
            return this.memberPersister.getIndexType();
        }
        if (string.equals("minIndex")) {
            return this.memberPersister.getIndexType();
        }
        if (string.equals("maxElement")) {
            return this.memberPersister.getElementType();
        }
        if (string.equals("minElement")) {
            return this.memberPersister.getElementType();
        }
        throw new QueryException("illegal syntax near collection: " + string);
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        if (string2.equals("elements")) {
            return this.memberPersister.getElementColumnNames(string);
        }
        if (string2.equals("indices")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection in indices()");
            }
            return this.memberPersister.getIndexColumnNames(string);
        }
        if (string2.equals("size")) {
            String[] stringArray = this.memberPersister.getKeyColumnNames();
            return new String[]{"count(" + string + '.' + stringArray[0] + ')'};
        }
        if (string2.equals("maxIndex")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection in maxIndex()");
            }
            String[] stringArray = this.memberPersister.getIndexColumnNames(string);
            if (stringArray.length != 1) {
                throw new QueryException("composite collection index in maxIndex()");
            }
            return new String[]{"max(" + stringArray[0] + ')'};
        }
        if (string2.equals("minIndex")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection in minIndex()");
            }
            String[] stringArray = this.memberPersister.getIndexColumnNames(string);
            if (stringArray.length != 1) {
                throw new QueryException("composite collection index in minIndex()");
            }
            return new String[]{"min(" + stringArray[0] + ')'};
        }
        if (string2.equals("maxElement")) {
            String[] stringArray = this.memberPersister.getElementColumnNames(string);
            if (stringArray.length != 1) {
                throw new QueryException("composite collection element in maxElement()");
            }
            return new String[]{"max(" + stringArray[0] + ')'};
        }
        if (string2.equals("minElement")) {
            String[] stringArray = this.memberPersister.getElementColumnNames(string);
            if (stringArray.length != 1) {
                throw new QueryException("composite collection element in minElement()");
            }
            return new String[]{"min(" + stringArray[0] + ')'};
        }
        throw new QueryException("illegal syntax near collection: " + string2);
    }

    public String[] toColumns(String string) throws QueryException, UnsupportedOperationException {
        throw new UnsupportedOperationException("References to collections must be define a SQL alias");
    }

    public Type getType() {
        return this.memberPersister.getCollectionType();
    }
}

