/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializerBuilder;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectCollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.Update;
import org.hibernate.type.AssociationType;

public class BasicCollectionPersister
extends AbstractCollectionPersister {
    private BasicBatchKey updateBatchKey;

    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    public BasicCollectionPersister(Collection collection, CollectionRegionAccessStrategy collectionRegionAccessStrategy, Configuration configuration, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException, CacheException {
        super(collection, collectionRegionAccessStrategy, configuration, sessionFactoryImplementor);
    }

    protected String generateDeleteString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName).addPrimaryKeyColumns(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection " + this.getRole());
        }
        return delete.toStatementString();
    }

    protected String generateInsertRowString() {
        Insert insert = new Insert(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames, this.indexColumnIsSettable);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert collection row " + this.getRole());
        }
        insert.addColumns(this.elementColumnNames, this.elementColumnIsSettable, this.elementColumnWriters);
        return insert.toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName);
        update.addColumns(this.elementColumnNames, this.elementColumnIsSettable, this.elementColumnWriters);
        if (this.hasIdentifier) {
            update.addPrimaryKeyColumns(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            update.addPrimaryKeyColumns(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            update.addPrimaryKeyColumns(this.keyColumnNames);
            update.addPrimaryKeyColumns(this.elementColumnNames, this.elementColumnIsInPrimaryKey, this.elementColumnWriters);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update collection row " + this.getRole());
        }
        return update.toStatementString();
    }

    protected void doProcessQueuedOps(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
    }

    protected String generateDeleteRowString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName);
        if (this.hasIdentifier) {
            delete.addPrimaryKeyColumns(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            delete.addPrimaryKeyColumns(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            delete.addPrimaryKeyColumns(this.keyColumnNames);
            delete.addPrimaryKeyColumns(this.elementColumnNames, this.elementColumnIsInPrimaryKey, this.elementColumnWriters);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection row " + this.getRole());
        }
        return delete.toStatementString();
    }

    public boolean consumesEntityAlias() {
        return false;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    protected int doUpdateRows(Serializable serializable, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        if (ArrayHelper.isAllFalse(this.elementColumnIsSettable)) {
            return 0;
        }
        try {
            PreparedStatement preparedStatement = null;
            Expectation expectation = Expectations.appropriateExpectation(this.getUpdateCheckStyle());
            boolean bl = this.isUpdateCallable();
            boolean bl2 = expectation.canBeBatched();
            Iterator iterator = persistentCollection.entries(this);
            String string = this.getSQLUpdateRowString();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (persistentCollection.needsUpdating(e, n, this.elementType)) {
                    int n3 = 1;
                    if (bl2) {
                        if (this.updateBatchKey == null) {
                            this.updateBatchKey = new BasicBatchKey(this.getRole() + "#UPDATE", expectation);
                        }
                        preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.updateBatchKey).getBatchStatement(string, bl);
                    } else {
                        preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, bl);
                    }
                    try {
                        int n4 = this.writeElement(preparedStatement, persistentCollection.getElement(e), n3 += expectation.prepare(preparedStatement), sessionImplementor);
                        if (this.hasIdentifier) {
                            this.writeIdentifier(preparedStatement, persistentCollection.getIdentifier(e, n), n4, sessionImplementor);
                        } else {
                            n4 = this.writeKey(preparedStatement, serializable, n4, sessionImplementor);
                            if (this.hasIndex && !this.indexContainsFormula) {
                                this.writeIndexToWhere(preparedStatement, persistentCollection.getIndex(e, n, this), n4, sessionImplementor);
                            } else {
                                this.writeElementToWhere(preparedStatement, persistentCollection.getSnapshotElement(e, n), n4, sessionImplementor);
                            }
                        }
                        if (bl2) {
                            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getBatch(this.updateBatchKey).addToBatch();
                        } else {
                            expectation.verifyOutcome(sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement), preparedStatement, -1);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (bl2) {
                            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().abortBatch();
                        }
                        throw sQLException;
                    }
                    finally {
                        if (!bl2) {
                            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw this.getSQLExceptionHelper().convert(sQLException, "could not update collection rows: " + MessageHelper.collectionInfoString(this, persistentCollection, serializable, sessionImplementor), this.getSQLUpdateRowString());
        }
    }

    public String selectFragment(Joinable joinable, String string, String string2, String string3, String string4, boolean bl) {
        AssociationType associationType;
        if (joinable != null && this.isManyToMany() && !joinable.isCollection() && joinable.equals((associationType = (AssociationType)this.getElementType()).getAssociatedJoinable(this.getFactory()))) {
            return this.manyToManySelectFragment(joinable, string, string2, string4);
        }
        return bl ? this.selectFragment(string2, string4) : "";
    }

    private String manyToManySelectFragment(Joinable joinable, String string, String string2, String string3) {
        SelectFragment selectFragment = this.generateSelectFragment(string2, string3);
        String[] stringArray = joinable.getKeyColumnNames();
        selectFragment.addColumns(string, stringArray, this.elementColumnAliases);
        this.appendIndexColumns(selectFragment, string2);
        this.appendIdentifierColumns(selectFragment, string2);
        return selectFragment.toFragmentString().substring(2);
    }

    protected CollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return BatchingCollectionInitializerBuilder.getBuilder(this.getFactory()).createBatchingCollectionInitializer(this, this.batchSize, this.getFactory(), loadQueryInfluencers);
    }

    public String fromJoinFragment(String string, boolean bl, boolean bl2) {
        return "";
    }

    public String whereJoinFragment(String string, boolean bl, boolean bl2) {
        return "";
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselectFetch, SessionImplementor sessionImplementor) {
        return new SubselectCollectionLoader(this, subselectFetch.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselectFetch.getResult(), subselectFetch.getQueryParameters(), subselectFetch.getNamedParameterLocMap(), sessionImplementor.getFactory(), sessionImplementor.getLoadQueryInfluencers());
    }

    public FilterAliasGenerator getFilterAliasGenerator(String string) {
        return new StaticFilterAliasGenerator(string);
    }
}

