/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.param.AbstractExplicitParameterSpecification;
import org.hibernate.type.Type;

public class PositionalParameterSpecification
extends AbstractExplicitParameterSpecification {
    private final int hqlPosition;

    public PositionalParameterSpecification(int n, int n2, int n3) {
        super(n, n2);
        this.hqlPosition = n3;
    }

    public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
        Type type = queryParameters.getPositionalParameterTypes()[this.hqlPosition];
        Object object = queryParameters.getPositionalParameterValues()[this.hqlPosition];
        type.nullSafeSet(preparedStatement, object, n, sessionImplementor);
        return type.getColumnSpan(sessionImplementor.getFactory());
    }

    public String renderDisplayInfo() {
        return "ordinal=" + this.hqlPosition + ", expectedType=" + this.getExpectedType();
    }

    public int getHqlPosition() {
        return this.hqlPosition;
    }
}

