/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class CollectionFilterKeyParameterSpecification
implements ParameterSpecification {
    private final String collectionRole;
    private final Type keyType;
    private final int queryParameterPosition;

    public CollectionFilterKeyParameterSpecification(String string, Type type, int n) {
        this.collectionRole = string;
        this.keyType = type;
        this.queryParameterPosition = n;
    }

    public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
        Object object = queryParameters.getPositionalParameterValues()[this.queryParameterPosition];
        this.keyType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
        return this.keyType.getColumnSpan(sessionImplementor.getFactory());
    }

    public Type getExpectedType() {
        return this.keyType;
    }

    public void setExpectedType(Type type) {
    }

    public String renderDisplayInfo() {
        return "collection-filter-key=" + this.collectionRole;
    }
}

