/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.SessionFactoryBuilder;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    SessionFactoryOptionsImpl options;
    private final MetadataImplementor metadata;

    SessionFactoryBuilderImpl(MetadataImplementor metadataImplementor) {
        this.metadata = metadataImplementor;
        this.options = new SessionFactoryOptionsImpl();
    }

    public SessionFactoryBuilder with(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    public SessionFactoryBuilder with(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    public SessionFactory buildSessionFactory() {
        return new SessionFactoryImpl(this.metadata, this.options, null);
    }

    private static class SessionFactoryOptionsImpl
    implements SessionFactory.SessionFactoryOptions {
        private Interceptor interceptor = EmptyInterceptor.INSTANCE;
        private EntityNotFoundDelegate entityNotFoundDelegate = new EntityNotFoundDelegate(){

            public void handleEntityNotFound(String string, Serializable serializable) {
                throw new ObjectNotFoundException(serializable, string);
            }
        };

        private SessionFactoryOptionsImpl() {
        }

        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }
    }
}

