/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.DuplicateMappingException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataSourceProcessingOrder;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.SessionFactoryBuilder;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.domain.BasicType;
import org.hibernate.metamodel.relational.Database;
import org.hibernate.metamodel.source.MappingDefaults;
import org.hibernate.metamodel.source.MetaAttributeContext;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.MetadataSourceProcessor;
import org.hibernate.metamodel.source.annotations.AnnotationMetadataSourceProcessorImpl;
import org.hibernate.metamodel.source.hbm.HbmMetadataSourceProcessorImpl;
import org.hibernate.metamodel.source.internal.AssociationResolver;
import org.hibernate.metamodel.source.internal.HibernateTypeResolver;
import org.hibernate.metamodel.source.internal.IdentifierGeneratorResolver;
import org.hibernate.metamodel.source.internal.SessionFactoryBuilderImpl;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, MetadataImpl.class.getName());
    private final ServiceRegistry serviceRegistry;
    private final Metadata.Options options;
    private final ValueHolder<ClassLoaderService> classLoaderService;
    private final ValueHolder<PersisterClassResolver> persisterClassResolverService;
    private TypeResolver typeResolver = new TypeResolver();
    private SessionFactoryBuilder sessionFactoryBuilder = new SessionFactoryBuilderImpl(this);
    private final MutableIdentifierGeneratorFactory identifierGeneratorFactory;
    private final Database database;
    private final MappingDefaults mappingDefaults;
    private Map<String, EntityBinding> entityBindingMap = new HashMap<String, EntityBinding>();
    private Map<String, PluralAttributeBinding> collectionBindingMap = new HashMap<String, PluralAttributeBinding>();
    private Map<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
    private Map<String, String> imports = new HashMap<String, String>();
    private Map<String, TypeDef> typeDefs = new HashMap<String, TypeDef>();
    private Map<String, IdGenerator> idGenerators = new HashMap<String, IdGenerator>();
    private Map<String, NamedQueryDefinition> namedQueryDefs = new HashMap<String, NamedQueryDefinition>();
    private Map<String, NamedSQLQueryDefinition> namedNativeQueryDefs = new HashMap<String, NamedSQLQueryDefinition>();
    private Map<String, ResultSetMappingDefinition> resultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
    private Map<String, FilterDefinition> filterDefs = new HashMap<String, FilterDefinition>();
    private boolean globallyQuotedIdentifiers = false;
    private final MetaAttributeContext globalMetaAttributeContext = new MetaAttributeContext();
    private static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private static final String DEFAULT_CASCADE = "none";
    private static final String DEFAULT_PROPERTY_ACCESS = "property";

    public MetadataImpl(MetadataSources metadataSources, Metadata.Options options) {
        this.serviceRegistry = metadataSources.getServiceRegistry();
        this.options = options;
        this.identifierGeneratorFactory = this.serviceRegistry.getService(MutableIdentifierGeneratorFactory.class);
        this.database = new Database(options);
        this.mappingDefaults = new MappingDefaultsImpl();
        MetadataSourceProcessor[] metadataSourceProcessorArray = options.getMetadataSourceProcessingOrder() == MetadataSourceProcessingOrder.HBM_FIRST ? new MetadataSourceProcessor[]{new HbmMetadataSourceProcessorImpl(this), new AnnotationMetadataSourceProcessorImpl(this)} : new MetadataSourceProcessor[]{new AnnotationMetadataSourceProcessorImpl(this), new HbmMetadataSourceProcessorImpl(this)};
        this.classLoaderService = new ValueHolder<1>(new ValueHolder.DeferredInitializer<ClassLoaderService>(){

            @Override
            public ClassLoaderService initialize() {
                return MetadataImpl.this.serviceRegistry.getService(ClassLoaderService.class);
            }
        });
        this.persisterClassResolverService = new ValueHolder<2>(new ValueHolder.DeferredInitializer<PersisterClassResolver>(){

            @Override
            public PersisterClassResolver initialize() {
                return MetadataImpl.this.serviceRegistry.getService(PersisterClassResolver.class);
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        this.prepare(metadataSourceProcessorArray, metadataSources);
        this.bindIndependentMetadata(metadataSourceProcessorArray, metadataSources);
        this.bindTypeDependentMetadata(metadataSourceProcessorArray, metadataSources);
        this.bindMappingMetadata(metadataSourceProcessorArray, metadataSources, arrayList);
        this.bindMappingDependentMetadata(metadataSourceProcessorArray, metadataSources);
        new AssociationResolver(this).resolve();
        new HibernateTypeResolver(this).resolve();
        new IdentifierGeneratorResolver(this).resolve();
    }

    private void prepare(MetadataSourceProcessor[] metadataSourceProcessorArray, MetadataSources metadataSources) {
        for (MetadataSourceProcessor metadataSourceProcessor : metadataSourceProcessorArray) {
            metadataSourceProcessor.prepare(metadataSources);
        }
    }

    private void bindIndependentMetadata(MetadataSourceProcessor[] metadataSourceProcessorArray, MetadataSources metadataSources) {
        for (MetadataSourceProcessor metadataSourceProcessor : metadataSourceProcessorArray) {
            metadataSourceProcessor.processIndependentMetadata(metadataSources);
        }
    }

    private void bindTypeDependentMetadata(MetadataSourceProcessor[] metadataSourceProcessorArray, MetadataSources metadataSources) {
        for (MetadataSourceProcessor metadataSourceProcessor : metadataSourceProcessorArray) {
            metadataSourceProcessor.processTypeDependentMetadata(metadataSources);
        }
    }

    private void bindMappingMetadata(MetadataSourceProcessor[] metadataSourceProcessorArray, MetadataSources metadataSources, List<String> list) {
        for (MetadataSourceProcessor metadataSourceProcessor : metadataSourceProcessorArray) {
            metadataSourceProcessor.processMappingMetadata(metadataSources, list);
        }
    }

    private void bindMappingDependentMetadata(MetadataSourceProcessor[] metadataSourceProcessorArray, MetadataSources metadataSources) {
        for (MetadataSourceProcessor metadataSourceProcessor : metadataSourceProcessorArray) {
            metadataSourceProcessor.processMappingDependentMetadata(metadataSources);
        }
    }

    @Override
    public void addFetchProfile(FetchProfile fetchProfile) {
        if (fetchProfile == null || fetchProfile.getName() == null) {
            throw new IllegalArgumentException("Fetch profile object or name is null: " + fetchProfile);
        }
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    @Override
    public void addFilterDefinition(FilterDefinition filterDefinition) {
        if (filterDefinition == null || filterDefinition.getFilterName() == null) {
            throw new IllegalArgumentException("Filter definition object or name is null: " + filterDefinition);
        }
        this.filterDefs.put(filterDefinition.getFilterName(), filterDefinition);
    }

    @Override
    public Iterable<FilterDefinition> getFilterDefinitions() {
        return this.filterDefs.values();
    }

    @Override
    public void addIdGenerator(IdGenerator idGenerator) {
        if (idGenerator == null || idGenerator.getName() == null) {
            throw new IllegalArgumentException("ID generator object or name is null.");
        }
        this.idGenerators.put(idGenerator.getName(), idGenerator);
    }

    @Override
    public IdGenerator getIdGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null is not a valid generator name");
        }
        return this.idGenerators.get(string);
    }

    @Override
    public void registerIdentifierGenerator(String string, String string2) {
        this.identifierGeneratorFactory.register(string, this.classLoaderService().classForName(string2));
    }

    @Override
    public void addNamedNativeQuery(NamedSQLQueryDefinition namedSQLQueryDefinition) {
        if (namedSQLQueryDefinition == null || namedSQLQueryDefinition.getName() == null) {
            throw new IllegalArgumentException("Named native query definition object or name is null: " + namedSQLQueryDefinition.getQueryString());
        }
        this.namedNativeQueryDefs.put(namedSQLQueryDefinition.getName(), namedSQLQueryDefinition);
    }

    public NamedSQLQueryDefinition getNamedNativeQuery(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null is not a valid native query name");
        }
        return this.namedNativeQueryDefs.get(string);
    }

    @Override
    public Iterable<NamedSQLQueryDefinition> getNamedNativeQueryDefinitions() {
        return this.namedNativeQueryDefs.values();
    }

    @Override
    public void addNamedQuery(NamedQueryDefinition namedQueryDefinition) {
        if (namedQueryDefinition == null) {
            throw new IllegalArgumentException("Named query definition is null");
        }
        if (namedQueryDefinition.getName() == null) {
            throw new IllegalArgumentException("Named query definition name is null: " + namedQueryDefinition.getQueryString());
        }
        this.namedQueryDefs.put(namedQueryDefinition.getName(), namedQueryDefinition);
    }

    public NamedQueryDefinition getNamedQuery(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null is not a valid query name");
        }
        return this.namedQueryDefs.get(string);
    }

    @Override
    public Iterable<NamedQueryDefinition> getNamedQueryDefinitions() {
        return this.namedQueryDefs.values();
    }

    @Override
    public void addResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) {
        if (resultSetMappingDefinition == null || resultSetMappingDefinition.getName() == null) {
            throw new IllegalArgumentException("Result-set mapping object or name is null: " + resultSetMappingDefinition);
        }
        this.resultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
    }

    @Override
    public Iterable<ResultSetMappingDefinition> getResultSetMappingDefinitions() {
        return this.resultSetMappings.values();
    }

    @Override
    public void addTypeDefinition(TypeDef typeDef) {
        if (typeDef == null) {
            throw new IllegalArgumentException("Type definition is null");
        }
        if (typeDef.getName() == null) {
            throw new IllegalArgumentException("Type definition name is null: " + typeDef.getTypeClass());
        }
        TypeDef typeDef2 = this.typeDefs.put(typeDef.getName(), typeDef);
        if (typeDef2 != null) {
            LOG.debugf("Duplicate typedef name [%s] now -> %s", (Object)typeDef.getName(), (Object)typeDef.getTypeClass());
        }
    }

    @Override
    public Iterable<TypeDef> getTypeDefinitions() {
        return this.typeDefs.values();
    }

    @Override
    public TypeDef getTypeDefinition(String string) {
        return this.typeDefs.get(string);
    }

    private ClassLoaderService classLoaderService() {
        return this.classLoaderService.getValue();
    }

    private PersisterClassResolver persisterClassResolverService() {
        return this.persisterClassResolverService.getValue();
    }

    @Override
    public Metadata.Options getOptions() {
        return this.options;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.sessionFactoryBuilder.buildSessionFactory();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public <T> Class<T> locateClassByName(String string) {
        return this.classLoaderService().classForName(string);
    }

    @Override
    public org.hibernate.metamodel.domain.Type makeJavaType(String string) {
        return new BasicType(string, this.makeClassReference(string));
    }

    @Override
    public ValueHolder<Class<?>> makeClassReference(final String string) {
        return new ValueHolder<3>(new ValueHolder.DeferredInitializer<Class<?>>(){

            @Override
            public Class<?> initialize() {
                return ((ClassLoaderService)MetadataImpl.this.classLoaderService.getValue()).classForName(string);
            }
        });
    }

    @Override
    public String qualifyClassName(String string) {
        return string;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public EntityBinding getEntityBinding(String string) {
        return this.entityBindingMap.get(string);
    }

    @Override
    public EntityBinding getRootEntityBinding(String string) {
        EntityBinding entityBinding = this.entityBindingMap.get(string);
        if (entityBinding == null) {
            throw new IllegalStateException("Unknown entity binding: " + string);
        }
        do {
            if (!entityBinding.isRoot()) continue;
            return entityBinding;
        } while ((entityBinding = entityBinding.getSuperEntityBinding()) != null);
        throw new AssertionFailure("Entity binding has no root: " + string);
    }

    @Override
    public Iterable<EntityBinding> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public void addEntity(EntityBinding entityBinding) {
        String string = entityBinding.getEntity().getName();
        if (this.entityBindingMap.containsKey(string)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, string);
        }
        this.entityBindingMap.put(string, entityBinding);
    }

    public PluralAttributeBinding getCollection(String string) {
        return this.collectionBindingMap.get(string);
    }

    @Override
    public Iterable<PluralAttributeBinding> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public void addCollection(PluralAttributeBinding pluralAttributeBinding) {
        String string = pluralAttributeBinding.getContainer().getPathBase();
        String string2 = pluralAttributeBinding.getAttribute().getName();
        String string3 = string + '.' + string2;
        if (this.collectionBindingMap.containsKey(string3)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, string3);
        }
        this.collectionBindingMap.put(string3, pluralAttributeBinding);
    }

    @Override
    public void addImport(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Import name or entity name is null");
        }
        LOG.tracev("Import: {0} -> {1}", (Object)string, (Object)string2);
        String string3 = this.imports.put(string, string2);
        if (string3 != null) {
            LOG.debug("import name [" + string + "] overrode previous [{" + string3 + "}]");
        }
    }

    @Override
    public Iterable<Map.Entry<String, String>> getImports() {
        return this.imports.entrySet();
    }

    @Override
    public Iterable<FetchProfile> getFetchProfiles() {
        return this.fetchProfiles.values();
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        return this.sessionFactoryBuilder;
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.options.getNamingStrategy();
    }

    @Override
    public boolean isGloballyQuotedIdentifiers() {
        return this.globallyQuotedIdentifiers || this.getOptions().isGloballyQuotedIdentifiers();
    }

    @Override
    public void setGloballyQuotedIdentifiers(boolean bl) {
        this.globallyQuotedIdentifiers = bl;
    }

    @Override
    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    @Override
    public MetaAttributeContext getGlobalMetaAttributeContext() {
        return this.globalMetaAttributeContext;
    }

    @Override
    public MetadataImplementor getMetadataImplementor() {
        return this;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    @Override
    public Type getIdentifierType(String string) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(string);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + string);
        }
        return entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding().getHibernateTypeDescriptor().getResolvedTypeMapping();
    }

    @Override
    public String getIdentifierPropertyName(String string) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(string);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + string);
        }
        BasicAttributeBinding basicAttributeBinding = entityBinding.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        return basicAttributeBinding == null ? null : basicAttributeBinding.getAttribute().getName();
    }

    @Override
    public Type getReferencedPropertyType(String string, String string2) throws MappingException {
        EntityBinding entityBinding = this.getEntityBinding(string);
        if (entityBinding == null) {
            throw new MappingException("Entity binding not known: " + string);
        }
        AttributeBinding attributeBinding = entityBinding.locateAttributeBinding(string2);
        if (attributeBinding == null) {
            throw new MappingException("unknown property: " + string + '.' + string2);
        }
        return attributeBinding.getHibernateTypeDescriptor().getResolvedTypeMapping();
    }

    private class MappingDefaultsImpl
    implements MappingDefaults {
        private final ValueHolder<AccessType> regionFactorySpecifiedDefaultAccessType = new ValueHolder<1>(new ValueHolder.DeferredInitializer<AccessType>(){

            @Override
            public AccessType initialize() {
                RegionFactory regionFactory = MetadataImpl.this.getServiceRegistry().getService(RegionFactory.class);
                return regionFactory.getDefaultAccessType();
            }
        });

        private MappingDefaultsImpl() {
        }

        public String getPackageName() {
            return null;
        }

        public String getSchemaName() {
            return MetadataImpl.this.options.getDefaultSchemaName();
        }

        public String getCatalogName() {
            return MetadataImpl.this.options.getDefaultCatalogName();
        }

        public String getIdColumnName() {
            return MetadataImpl.DEFAULT_IDENTIFIER_COLUMN_NAME;
        }

        public String getDiscriminatorColumnName() {
            return MetadataImpl.DEFAULT_DISCRIMINATOR_COLUMN_NAME;
        }

        public String getCascadeStyle() {
            return MetadataImpl.DEFAULT_CASCADE;
        }

        public String getPropertyAccessorName() {
            return MetadataImpl.DEFAULT_PROPERTY_ACCESS;
        }

        public boolean areAssociationsLazy() {
            return true;
        }

        public AccessType getCacheAccessType() {
            return MetadataImpl.this.options.getDefaultAccessType() != null ? MetadataImpl.this.options.getDefaultAccessType() : this.regionFactorySpecifiedDefaultAccessType.getValue();
        }
    }
}

