/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import javax.persistence.SharedCacheMode;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataBuilder;
import org.hibernate.metamodel.MetadataSourceProcessingOrder;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.config.spi.ConfigurationService;

public class MetadataBuilderImpl
implements MetadataBuilder {
    private final MetadataSources sources;
    private final OptionsImpl options;

    public MetadataBuilderImpl(MetadataSources metadataSources) {
        this.sources = metadataSources;
        this.options = new OptionsImpl(metadataSources.getServiceRegistry());
    }

    public MetadataBuilder with(NamingStrategy namingStrategy) {
        this.options.namingStrategy = namingStrategy;
        return this;
    }

    public MetadataBuilder with(MetadataSourceProcessingOrder metadataSourceProcessingOrder) {
        this.options.metadataSourceProcessingOrder = metadataSourceProcessingOrder;
        return this;
    }

    public MetadataBuilder with(SharedCacheMode sharedCacheMode) {
        this.options.sharedCacheMode = sharedCacheMode;
        return this;
    }

    public MetadataBuilder with(AccessType accessType) {
        this.options.defaultCacheAccessType = accessType;
        return this;
    }

    public MetadataBuilder withNewIdentifierGeneratorsEnabled(boolean bl) {
        this.options.useNewIdentifierGenerators = bl;
        return this;
    }

    public Metadata buildMetadata() {
        return new MetadataImpl(this.sources, this.options);
    }

    private static class OptionsImpl
    implements Metadata.Options {
        private MetadataSourceProcessingOrder metadataSourceProcessingOrder = MetadataSourceProcessingOrder.HBM_FIRST;
        private NamingStrategy namingStrategy = EJB3NamingStrategy.INSTANCE;
        private SharedCacheMode sharedCacheMode = SharedCacheMode.ENABLE_SELECTIVE;
        private AccessType defaultCacheAccessType;
        private boolean useNewIdentifierGenerators;
        private boolean globallyQuotedIdentifiers;
        private String defaultSchemaName;
        private String defaultCatalogName;

        public OptionsImpl(ServiceRegistry serviceRegistry) {
            ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
            this.defaultCacheAccessType = configurationService.getSetting("hibernate.cache.default_cache_concurrency_strategy", new ConfigurationService.Converter<AccessType>(){

                @Override
                public AccessType convert(Object object) {
                    return AccessType.fromExternalName(object.toString());
                }
            });
            this.useNewIdentifierGenerators = configurationService.getSetting("hibernate.id.new_generator_mappings", new ConfigurationService.Converter<Boolean>(){

                @Override
                public Boolean convert(Object object) {
                    return Boolean.parseBoolean(object.toString());
                }
            }, Boolean.valueOf(false));
            this.defaultSchemaName = configurationService.getSetting("hibernate.default_schema", new ConfigurationService.Converter<String>(){

                @Override
                public String convert(Object object) {
                    return object.toString();
                }
            }, null);
            this.defaultCatalogName = configurationService.getSetting("hibernate.default_catalog", new ConfigurationService.Converter<String>(){

                @Override
                public String convert(Object object) {
                    return object.toString();
                }
            }, null);
            this.globallyQuotedIdentifiers = configurationService.getSetting("hibernate.globally_quoted_identifiers", new ConfigurationService.Converter<Boolean>(){

                @Override
                public Boolean convert(Object object) {
                    return Boolean.parseBoolean(object.toString());
                }
            }, Boolean.valueOf(false));
        }

        public MetadataSourceProcessingOrder getMetadataSourceProcessingOrder() {
            return this.metadataSourceProcessingOrder;
        }

        public NamingStrategy getNamingStrategy() {
            return this.namingStrategy;
        }

        public AccessType getDefaultAccessType() {
            return this.defaultCacheAccessType;
        }

        public SharedCacheMode getSharedCacheMode() {
            return this.sharedCacheMode;
        }

        public boolean useNewIdentifierGenerators() {
            return this.useNewIdentifierGenerators;
        }

        public boolean isGloballyQuotedIdentifiers() {
            return this.globallyQuotedIdentifiers;
        }

        public String getDefaultSchemaName() {
            return this.defaultSchemaName;
        }

        public String getDefaultCatalogName() {
            return this.defaultCatalogName;
        }
    }
}

