/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.internal.jaxb.JaxbRoot;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntityMappings;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.XsdException;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JaxbHelper {
    private static final Logger log = Logger.getLogger(JaxbHelper.class);
    public static final String ASSUMED_ORM_XSD_VERSION = "2.0";
    private final MetadataSources metadataSources;
    private XMLInputFactory staxFactory;
    private static final QName ORM_VERSION_ATTRIBUTE_QNAME = new QName("version");
    public static final String HBM_SCHEMA_NAME = "org/hibernate/hibernate-mapping-4.0.xsd";
    public static final String ORM_1_SCHEMA_NAME = "org/hibernate/ejb/orm_1_0.xsd";
    public static final String ORM_2_SCHEMA_NAME = "org/hibernate/ejb/orm_2_0.xsd";
    private Schema hbmSchema;
    private Schema orm1Schema;
    private Schema orm2Schema;

    public JaxbHelper(MetadataSources metadataSources) {
        this.metadataSources = metadataSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxbRoot unmarshal(InputStream inputStream, Origin origin) {
        JaxbRoot jaxbRoot;
        XMLEventReader xMLEventReader = this.staxFactory().createXMLEventReader(inputStream);
        try {
            jaxbRoot = this.unmarshal(xMLEventReader, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    xMLEventReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new MappingException("Unable to create stax reader", xMLStreamException, origin);
            }
        }
        try {
            xMLEventReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jaxbRoot;
    }

    private XMLInputFactory staxFactory() {
        if (this.staxFactory == null) {
            this.staxFactory = this.buildStaxFactory();
        }
        return this.staxFactory;
    }

    private XMLInputFactory buildStaxFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        return xMLInputFactory;
    }

    private JaxbRoot unmarshal(XMLEventReader xMLEventReader, Origin origin) {
        Class clazz;
        Schema schema;
        Object object;
        Object object2;
        XMLEvent xMLEvent;
        try {
            xMLEvent = xMLEventReader.peek();
            while (xMLEvent != null && !xMLEvent.isStartElement()) {
                xMLEventReader.nextEvent();
                xMLEvent = xMLEventReader.peek();
            }
        }
        catch (Exception exception) {
            throw new MappingException("Error accessing stax stream", exception, origin);
        }
        if (xMLEvent == null) {
            throw new MappingException("Could not locate root element", origin);
        }
        String string = xMLEvent.asStartElement().getName().getLocalPart();
        if ("entity-mappings".equals(string)) {
            object2 = xMLEvent.asStartElement().getAttributeByName(ORM_VERSION_ATTRIBUTE_QNAME);
            object = object2 == null ? null : object2.getValue();
            schema = this.resolveSupportedOrmXsd((String)object);
            clazz = JaxbEntityMappings.class;
        } else {
            schema = this.hbmSchema();
            clazz = JaxbHibernateMapping.class;
        }
        object = new ContextProvidingValidationEventHandler();
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)object);
            object2 = unmarshaller.unmarshal(xMLEventReader);
        }
        catch (JAXBException jAXBException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to perform unmarshalling at line number ");
            stringBuilder.append(((ContextProvidingValidationEventHandler)object).getLineNumber());
            stringBuilder.append(" and column ");
            stringBuilder.append(((ContextProvidingValidationEventHandler)object).getColumnNumber());
            stringBuilder.append(". Message: ");
            stringBuilder.append(((ContextProvidingValidationEventHandler)object).getMessage());
            throw new MappingException(stringBuilder.toString(), jAXBException, origin);
        }
        return new JaxbRoot<Object>(object2, origin);
    }

    public JaxbRoot unmarshal(Document document, Origin origin) {
        Class clazz;
        Schema schema;
        Object object;
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new MappingException("No root element found", origin);
        }
        if ("entity-mappings".equals(element.getNodeName())) {
            object = element.getAttribute("version");
            schema = this.resolveSupportedOrmXsd((String)object);
            clazz = JaxbEntityMappings.class;
        } else {
            schema = this.hbmSchema();
            clazz = JaxbHibernateMapping.class;
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            object = unmarshaller.unmarshal((Source)new DOMSource(document));
        }
        catch (JAXBException jAXBException) {
            throw new MappingException("Unable to perform unmarshalling", jAXBException, origin);
        }
        return new JaxbRoot<Object>(object, origin);
    }

    private Schema resolveSupportedOrmXsd(String string) {
        String string2;
        String string3 = string2 = string == null ? ASSUMED_ORM_XSD_VERSION : string;
        if ("1.0".equals(string2)) {
            return this.orm1Schema();
        }
        if (ASSUMED_ORM_XSD_VERSION.equals(string2)) {
            return this.orm2Schema();
        }
        throw new IllegalArgumentException("Unsupported orm.xml XSD version encountered [" + string2 + "]");
    }

    private Schema hbmSchema() {
        if (this.hbmSchema == null) {
            this.hbmSchema = this.resolveLocalSchema(HBM_SCHEMA_NAME);
        }
        return this.hbmSchema;
    }

    private Schema orm1Schema() {
        if (this.orm1Schema == null) {
            this.orm1Schema = this.resolveLocalSchema(ORM_1_SCHEMA_NAME);
        }
        return this.orm1Schema;
    }

    private Schema orm2Schema() {
        if (this.orm2Schema == null) {
            this.orm2Schema = this.resolveLocalSchema(ORM_2_SCHEMA_NAME);
        }
        return this.orm2Schema;
    }

    private Schema resolveLocalSchema(String string) {
        return this.resolveLocalSchema(string, "http://www.w3.org/2001/XMLSchema");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema resolveLocalSchema(String string, String string2) {
        URL uRL = this.metadataSources.getServiceRegistry().getService(ClassLoaderService.class).locateResource(string);
        if (uRL == null) {
            throw new XsdException("Unable to locate schema [" + string + "] via classpath", string);
        }
        try {
            InputStream inputStream = uRL.openStream();
            try {
                StreamSource streamSource = new StreamSource(uRL.openStream());
                SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
                Schema schema = schemaFactory.newSchema(streamSource);
                return schema;
            }
            catch (SAXException sAXException) {
                throw new XsdException("Unable to load schema [" + string + "]", sAXException, string);
            }
            catch (IOException iOException) {
                throw new XsdException("Unable to load schema [" + string + "]", iOException, string);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.debugf("Problem closing schema stream [%s]", (Object)iOException.toString());
                }
            }
        }
        catch (IOException iOException) {
            throw new XsdException("Stream error handling schema url [" + uRL.toExternalForm() + "]", string);
        }
    }

    static class ContextProvidingValidationEventHandler
    implements ValidationEventHandler {
        private int lineNumber;
        private int columnNumber;
        private String message;

        ContextProvidingValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            ValidationEventLocator validationEventLocator = validationEvent.getLocator();
            this.lineNumber = validationEventLocator.getLineNumber();
            this.columnNumber = validationEventLocator.getColumnNumber();
            this.message = validationEvent.getMessage();
            return false;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

